/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.downloader;

import com.helpshift.android.commons.downloader.DownloadConfig;
import com.helpshift.android.commons.downloader.DownloadManager;
import com.helpshift.android.commons.downloader.contracts.OnDownloadFinishListener;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.models.CampaignSyncModel;
import com.helpshift.campaigns.observers.CampaignDownloadObserver;
import com.helpshift.campaigns.observers.CampaignStorageObserver;
import com.helpshift.campaigns.observers.CampaignSyncModelStorageObserver;
import com.helpshift.campaigns.storage.CampaignDownloaderKvStorage;
import com.helpshift.common.domain.HSThreadFactory;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.storage.StorageFactory;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.ImageUtil;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CampaignDownloader
implements CampaignSyncModelStorageObserver,
CampaignStorageObserver {
    private static final int KEEP_ALIVE_TIME = 1;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final int CORE_POOL_SIZE = 5;
    private static final int MAXIMUM_POOL_SIZE = 5;
    private static final String DOWNLOAD_DIRECTORY_PATH = HelpshiftContext.getApplicationContext().getPackageName() + "/helpshift/images/";
    private final DownloadManager downloadManager;
    private final DownloadConfig campaignDownloadConfig;
    private final DownloadConfig imageDownloadConfig;
    CampaignDownloadObserver observer;
    private HashMap<String, Integer> campaignsImageUrlRetryCounts;
    private CampaignDownloaderKvStorage campaignDownloaderKvStorage;

    public CampaignDownloader(CampaignDownloadObserver observer) {
        this.observer = observer;
        this.campaignDownloaderKvStorage = new CampaignDownloaderKvStorage(StorageFactory.getInstance().keyValueStorage);
        this.campaignsImageUrlRetryCounts = (HashMap)this.campaignDownloaderKvStorage.get("hs__campaigns_icon_image_retry_counts");
        if (this.campaignsImageUrlRetryCounts == null) {
            this.campaignsImageUrlRetryCounts = new HashMap();
        }
        LinkedBlockingQueue<Runnable> downloadRunnableQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor downloadExecutor = new ThreadPoolExecutor(5, 5, 1L, KEEP_ALIVE_TIME_UNIT, downloadRunnableQueue, new HSThreadFactory("cm-dwnld"));
        this.downloadManager = new DownloadManager(HelpshiftContext.getApplicationContext(), this.campaignDownloaderKvStorage, downloadExecutor);
        this.campaignDownloadConfig = new DownloadConfig.Builder().setUseCache(false).setWriteToFile(false).setIsNoMedia(false).setExternalStorageDirectoryPath(DOWNLOAD_DIRECTORY_PATH).create();
        this.imageDownloadConfig = new DownloadConfig.Builder().setUseCache(true).setWriteToFile(true).setIsNoMedia(true).setExternalStorageDirectoryPath(DOWNLOAD_DIRECTORY_PATH).create();
    }

    public void startCampaignDownload(final CampaignSyncModel newCampaign) {
        OnDownloadFinishListener downloadFinishListener = new OnDownloadFinishListener(){

            @Override
            public void onDownloadFinish(boolean success, String url, Object responseObject) {
                if (success) {
                    CampaignDownloader.this.observer.campaignDownloadCompleted(newCampaign, responseObject.toString());
                } else {
                    CampaignDownloader.this.observer.campaignDownloadFailed(newCampaign.campaignId);
                }
            }
        };
        this.downloadManager.startDownload(newCampaign.creativeUrl, this.campaignDownloadConfig, downloadFinishListener, null);
        this.observer.campaignDownloadStarted(newCampaign.campaignId);
    }

    public void startIconImageDownload(final String iconImageUrl, final String campaignId) {
        if (this.canDownloadImage(iconImageUrl)) {
            OnDownloadFinishListener iconImageDownloadListener = new OnDownloadFinishListener(){

                @Override
                public void onDownloadFinish(boolean success, String url, Object responseObject) {
                    if (success) {
                        String iconImageFilePath = responseObject.toString();
                        if (ImageUtil.isImageFileFormatSupported(iconImageFilePath)) {
                            CampaignDownloader.this.observer.iconImageDownloadCompleted(campaignId, iconImageFilePath);
                        } else {
                            new File(iconImageFilePath).delete();
                            CampaignDownloader.this.disableCorruptImageRetry(iconImageUrl);
                            CampaignDownloader.this.observer.iconImageDownloadFailed(campaignId);
                        }
                    } else {
                        CampaignDownloader.this.decrementCorruptImageRetryCount(iconImageUrl);
                        CampaignDownloader.this.observer.iconImageDownloadFailed(campaignId);
                    }
                }
            };
            this.incrementCorruptImageRetryCount(iconImageUrl);
            this.downloadManager.startDownload(iconImageUrl, this.imageDownloadConfig, iconImageDownloadListener, null);
        }
    }

    public void startCoverImageDownload(final String coverImageUrl, final String campaignId) {
        if (this.canDownloadImage(coverImageUrl)) {
            OnDownloadFinishListener coverImageDownloadListener = new OnDownloadFinishListener(){

                @Override
                public void onDownloadFinish(boolean success, String url, Object responseObject) {
                    if (success) {
                        String coverImageFilePath = responseObject.toString();
                        if (ImageUtil.isImageFileFormatSupported(coverImageFilePath)) {
                            ImageUtil.scaleDownAndSave(responseObject.toString(), 3);
                            CampaignDownloader.this.observer.coverImageDownloadCompleted(campaignId, responseObject.toString());
                        } else {
                            new File(coverImageFilePath).delete();
                            CampaignDownloader.this.disableCorruptImageRetry(coverImageUrl);
                            CampaignDownloader.this.observer.coverImageDownloadFailed(campaignId);
                        }
                    } else {
                        CampaignDownloader.this.decrementCorruptImageRetryCount(coverImageUrl);
                        CampaignDownloader.this.observer.coverImageDownloadFailed(campaignId);
                    }
                }
            };
            this.incrementCorruptImageRetryCount(coverImageUrl);
            this.downloadManager.startDownload(coverImageUrl, this.imageDownloadConfig, coverImageDownloadListener, null);
        }
    }

    @Override
    public void campaignAdded(CampaignSyncModel newCampaign) {
        this.startCampaignDownload(newCampaign);
    }

    @Override
    public void campaignSynced(String cid) {
    }

    @Override
    public void campaignDetailModelAdded(CampaignDetailModel campaignDetailModel) {
        Boolean muteNotifications = InfoModelFactory.getInstance().appInfoModel.muteNotifications;
        if (muteNotifications == null || !muteNotifications.booleanValue()) {
            this.startIconImageDownload(campaignDetailModel.iconImageUrl, campaignDetailModel.getIdentifier());
        }
    }

    @Override
    public void campaignIconImageFilePathUpdated(String campaignId) {
    }

    @Override
    public void campaignCoverImageFilePathUpdated(String campaignId) {
    }

    @Override
    public void campaignDeleted(String campaignId) {
    }

    @Override
    public void campaignRead(String campaignId) {
    }

    @Override
    public void campaignSeen(String campaignId) {
    }

    private void incrementCorruptImageRetryCount(String imageUrl) {
        Integer retryCount = this.campaignsImageUrlRetryCounts.get(imageUrl);
        if (retryCount == null) {
            this.campaignsImageUrlRetryCounts.put(imageUrl, 1);
        } else {
            this.campaignsImageUrlRetryCounts.put(imageUrl, retryCount + 1);
        }
        this.campaignDownloaderKvStorage.set("hs__campaigns_icon_image_retry_counts", this.campaignsImageUrlRetryCounts);
    }

    void decrementCorruptImageRetryCount(String imageUrl) {
        Integer retryCount = this.campaignsImageUrlRetryCounts.get(imageUrl);
        if (retryCount != null && retryCount > 0) {
            this.campaignsImageUrlRetryCounts.put(imageUrl, retryCount - 1);
            this.campaignDownloaderKvStorage.set("hs__campaigns_icon_image_retry_counts", this.campaignsImageUrlRetryCounts);
        }
    }

    void disableCorruptImageRetry(String imageUrl) {
        this.campaignsImageUrlRetryCounts.put(imageUrl, 5);
        this.campaignDownloaderKvStorage.set("hs__campaigns_icon_image_retry_counts", this.campaignsImageUrlRetryCounts);
    }

    public void enableCorruptImageRetry(String imageUrl) {
        this.campaignsImageUrlRetryCounts.put(imageUrl, 0);
        this.campaignDownloaderKvStorage.set("hs__campaigns_icon_image_retry_counts", this.campaignsImageUrlRetryCounts);
    }

    private boolean canDownloadImage(String imageUrl) {
        Integer retryCount = this.campaignsImageUrlRetryCounts.get(imageUrl);
        boolean canRetry = true;
        if (retryCount == null) {
            this.campaignsImageUrlRetryCounts.put(imageUrl, 0);
            this.campaignDownloaderKvStorage.set("hs__campaigns_icon_image_retry_counts", this.campaignsImageUrlRetryCounts);
        } else if (retryCount >= 5) {
            canRetry = false;
        }
        return canRetry;
    }
}

