/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.fragments;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.campaigns.fragments.InboxFragment;
import com.helpshift.campaigns.fragments.MainFragment;
import com.helpshift.campaigns.interactors.CampaignDetailInteractor;
import com.helpshift.campaigns.observers.CampaignDetailPresenterObserver;
import com.helpshift.campaigns.presenters.CampaignDetailPresenter;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.campaigns.storage.CampaignSyncModelStorage;
import com.helpshift.campaigns.storage.StorageFactory;
import com.helpshift.campaigns.util.FragmentUtil;
import com.helpshift.campaigns.views.AdjustableImageView;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.views.HSSnackbar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CampaignDetailFragment
extends MainFragment
implements CampaignDetailPresenterObserver {
    private static final String TAG = "Helpshift_CampDetails";
    CampaignDetailPresenter presenter;
    private String campaignId;
    private AdjustableImageView coverImageView;
    private ProgressBar coverImageProgressbar;
    private TextView titleTextView;
    private TextView bodyTextView;
    private List<Button> actionButtons;
    private ProgressBar progressBar;
    private ViewStub expiredMessageViewStub;
    private LinearLayout expiredMessageView;
    private ScrollView campaignDetailViewContainer;

    public static CampaignDetailFragment newInstance(Bundle bundle) {
        CampaignDetailFragment campaignDetailFragment = new CampaignDetailFragment();
        campaignDetailFragment.setArguments(bundle);
        return campaignDetailFragment;
    }

    @Override
    protected boolean shouldRetainInstance() {
        return !this.isTablet();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.campaignId = this.getArguments().getString("campaignId");
        CampaignStorage storage = StorageFactory.getInstance().campaignStorage;
        CampaignSyncModelStorage syncModelStorage = StorageFactory.getInstance().campaignSyncModelStorage;
        CampaignDetailInteractor interactor = CampaignDetailInteractor.newInstance(this.campaignId, storage, syncModelStorage);
        if (interactor != null) {
            this.presenter = new CampaignDetailPresenter(interactor);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.presenter != null) {
            this.presenter.setUp();
            this.presenter.addObserver(this);
        }
        return inflater.inflate(R.layout.hs__campaign_detail_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.coverImageView = (AdjustableImageView)view.findViewById(R.id.campaign_cover_image);
        this.coverImageProgressbar = (ProgressBar)view.findViewById(R.id.campaign_cover_image_progress);
        this.titleTextView = (TextView)view.findViewById(R.id.campaign_title);
        this.bodyTextView = (TextView)view.findViewById(R.id.campaign_body);
        this.actionButtons = new ArrayList<Button>();
        this.actionButtons.add((Button)view.findViewById(R.id.action1_button));
        this.actionButtons.add((Button)view.findViewById(R.id.action2_button));
        this.actionButtons.add((Button)view.findViewById(R.id.action3_button));
        this.actionButtons.add((Button)view.findViewById(R.id.action4_button));
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
        this.campaignDetailViewContainer = (ScrollView)view.findViewById(R.id.campaign_detail_view_container);
        this.expiredMessageViewStub = (ViewStub)view.findViewById(R.id.hs__campaign_expired_view_stub);
        HSLogger.d(TAG, "Showing Campaign details");
    }

    void invalidateUiElements() {
        if (this.presenter != null) {
            View rootView = this.getView();
            if (this.presenter.isExpired()) {
                if (this.expiredMessageView == null) {
                    this.expiredMessageView = (LinearLayout)this.expiredMessageViewStub.inflate();
                }
                this.expiredMessageView.setVisibility(0);
                this.campaignDetailViewContainer.setVisibility(8);
                if (rootView != null) {
                    rootView.setBackgroundColor(0);
                }
            } else {
                if (this.expiredMessageView != null) {
                    this.expiredMessageView.setVisibility(8);
                }
                this.campaignDetailViewContainer.setVisibility(0);
                if (TextUtils.isEmpty((CharSequence)this.presenter.getTitle())) {
                    this.progressBar.setVisibility(0);
                } else {
                    this.progressBar.setVisibility(8);
                }
                HashMap<String, Object> coverImageBitmapInfo = this.presenter.getCoverImage();
                Bitmap coverImageBitmap = (Bitmap)coverImageBitmapInfo.get("bitmap");
                if (coverImageBitmap != null) {
                    this.coverImageView.setImageBitmap(coverImageBitmap);
                    if (coverImageBitmapInfo.containsKey("default")) {
                        this.coverImageProgressbar.setVisibility(0);
                    } else {
                        this.coverImageProgressbar.setVisibility(8);
                    }
                }
                this.titleTextView.setText((CharSequence)this.presenter.getTitle());
                if (!TextUtils.isEmpty((CharSequence)this.presenter.getTitleColor())) {
                    try {
                        this.titleTextView.setTextColor(Color.parseColor((String)this.presenter.getTitleColor()));
                    }
                    catch (IllegalArgumentException e) {
                        HSLogger.d(TAG, "Error while parsing title color", e);
                    }
                }
                this.bodyTextView.setText((CharSequence)this.presenter.getBody());
                if (!TextUtils.isEmpty((CharSequence)this.presenter.getTextColor())) {
                    try {
                        this.bodyTextView.setTextColor(Color.parseColor((String)this.presenter.getTextColor()));
                    }
                    catch (IllegalArgumentException e) {
                        HSLogger.d(TAG, "Error while parsing body color", e);
                    }
                }
                if (rootView != null && !TextUtils.isEmpty((CharSequence)this.presenter.getBackgroundColor())) {
                    try {
                        rootView.setBackgroundColor(Color.parseColor((String)this.presenter.getBackgroundColor()));
                    }
                    catch (IllegalArgumentException e) {
                        HSLogger.d(TAG, "Error while parsing background color", e);
                    }
                }
                int i = 0;
                while (i < this.presenter.getCountOfActions()) {
                    Button actionButton = this.actionButtons.get(i);
                    actionButton.setText((CharSequence)this.presenter.getActionTitle(i));
                    actionButton.setTextColor(Color.parseColor((String)this.presenter.getActionTitleColor(i)));
                    final int buttonIndex = i++;
                    actionButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            CampaignDetailFragment.this.presenter.buttonClicked(buttonIndex, (Activity)CampaignDetailFragment.this.getActivity());
                        }
                    });
                    actionButton.setVisibility(0);
                }
            }
        } else {
            HSSnackbar.make(this.getView(), R.string.hs__data_not_found_msg, 0).show();
        }
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.getString(R.string.hs__cam_message));
        this.invalidateUiElements();
        if (this.presenter != null) {
            this.presenter.markCampaignAsSeen();
            ApplicationUtil.cancelNotification(this.campaignId);
            HSLogger.d(TAG, "Campaign title : " + this.presenter.getTitle());
        }
    }

    public void onPause() {
        super.onPause();
        if (this.presenter != null) {
            this.presenter.cleanUp();
            this.presenter.removeObserver(this);
        }
    }

    @Override
    public void onStop() {
        InboxFragment inboxFragment;
        super.onStop();
        if (!this.isChangingConfigurations() && !this.isDualPane() && (inboxFragment = FragmentUtil.getInboxFragment(this)) != null) {
            inboxFragment.setShowDetailFragment(false);
        }
    }

    @Override
    public void dataChanged() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                CampaignDetailFragment.this.invalidateUiElements();
            }
        });
    }
}

