/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.fragments;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.campaigns.adapters.CampaignListAdapter;
import com.helpshift.campaigns.callbacks.CampaignListItemTouchHelperCallback;
import com.helpshift.campaigns.fragments.InboxFragment;
import com.helpshift.campaigns.fragments.MainFragment;
import com.helpshift.campaigns.interactors.CampaignsListInteractor;
import com.helpshift.campaigns.listeners.CampaignListFragmentListener;
import com.helpshift.campaigns.observers.CampaignListPresenterObserver;
import com.helpshift.campaigns.presenters.CampaignListPresenter;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.campaigns.storage.StorageFactory;
import com.helpshift.campaigns.util.FragmentUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.Styles;
import com.helpshift.views.HSMenuItemCompat;
import com.helpshift.views.HSSnackbar;

public class CampaignListFragment
extends MainFragment
implements CampaignListPresenterObserver {
    private static final String TAG = "Helpshift_CampaignList";
    private View.OnClickListener onCampaignClickListener;
    CampaignListAdapter adapter;
    CampaignListPresenter presenter;
    private TextView noCampaignsView;
    private Snackbar undoSnackbar;
    MenuItem searchMenuItem;
    private SearchView searchView;
    private boolean presenterSetup = false;

    public static CampaignListFragment newInstance() {
        CampaignListFragment fragment = new CampaignListFragment();
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        CampaignStorage storage = StorageFactory.getInstance().campaignStorage;
        CampaignsListInteractor interactor = new CampaignsListInteractor(storage);
        this.presenter = new CampaignListPresenter(interactor);
        InboxFragment inboxFragment = FragmentUtil.getInboxFragment(this);
        if (this.isDualPane() || inboxFragment != null && !inboxFragment.getShowDetailFragment()) {
            this.presenter.setUp();
            this.presenter.addObserver(this);
        }
        this.presenterSetup = true;
        this.onCampaignClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                String campaignId = (String)v.getTag();
                if (HSMenuItemCompat.isActionViewExpanded(CampaignListFragment.this.searchMenuItem)) {
                    CampaignListFragment.this.presenter.setCampaignClickedFromSearchResult(true);
                    CampaignListFragment.this.presenter.setRetainSearchState(true);
                }
                CampaignListFragment.this.getCampaignListFragmentListener().onCampaignClicked(campaignId);
            }
        };
        return inflater.inflate(R.layout.hs__campaign_list_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        RecyclerView inboxList = (RecyclerView)view.findViewById(R.id.inbox_list);
        inboxList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
        this.adapter = new CampaignListAdapter(this.presenter, this.onCampaignClickListener);
        inboxList.setAdapter((RecyclerView.Adapter)this.adapter);
        CampaignListItemTouchHelperCallback campaignListItemTouchHelperCallback = new CampaignListItemTouchHelperCallback(this.getContext(), this);
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)campaignListItemTouchHelperCallback);
        itemTouchHelper.attachToRecyclerView(inboxList);
        this.noCampaignsView = (TextView)view.findViewById(R.id.view_no_campaigns);
        this.updateEmptyView();
        HSLogger.d(TAG, "Showing Campaigns list fragment");
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.getString(R.string.hs__cam_inbox));
        if (!this.presenterSetup) {
            this.presenter.setUp();
            this.presenter.addObserver(this);
        }
        this.presenter.cleanUpExpiredCampaigns();
        this.dataChanged();
    }

    public void onPause() {
        super.onPause();
        this.dismissSnackbar();
        this.presenter.cleanUp();
        this.presenter.removeObserver(this);
        this.presenterSetup = false;
    }

    void updateEmptyView() {
        if (this.presenter.getCountOfCampaigns() == 0) {
            this.noCampaignsView.setVisibility(0);
        } else {
            this.noCampaignsView.setVisibility(8);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void removeItem(final int position, boolean withUndo) {
        this.getCampaignListFragmentListener().onCampaignDelete(this.presenter.getCampaignId(position));
        if (withUndo) {
            this.undoSnackbar = HSSnackbar.make(this.getView(), R.string.hs__cam_message_deleted, 0).setAction(R.string.hs__cam_undo, new View.OnClickListener(){

                public void onClick(View v) {
                    CampaignListFragment.this.presenter.undoDeletedCampaign();
                    CampaignListFragment.this.adapter.notifyItemInserted(position);
                    CampaignListFragment.this.updateEmptyView();
                }
            }).setCallback(new Snackbar.Callback(){

                public void onDismissed(Snackbar snackbar, int event) {
                    super.onDismissed(snackbar, event);
                    if (event != 1 && event != 4) {
                        CampaignListFragment.this.presenter.undoTimedOut();
                    }
                }
            });
            this.undoSnackbar.show();
        }
        this.adapter.removeItem(position, withUndo);
        this.updateEmptyView();
    }

    @Override
    protected int getMenuResourceId() {
        return R.menu.hs__campaign_list_menu;
    }

    @Override
    protected void attachMenuListeners(Menu menu2) {
        this.searchMenuItem = menu2.findItem(R.id.hs__search);
        this.searchView = (SearchView)HSMenuItemCompat.getActionView(this.searchMenuItem);
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this.presenter);
        HSMenuItemCompat.setOnActionExpandListener(this.searchMenuItem, this.presenter);
        Styles.setActionButtonIconColor(this.getContext(), this.searchMenuItem.getIcon());
        this.restoreSearchMenuItem();
    }

    private void restoreSearchMenuItem() {
        if (this.presenter.getRetainSearchState()) {
            this.setSearchMenuQuery(this.presenter.getCurrentQuery());
            this.presenter.setRetainSearchState(false);
        }
    }

    public void setSearchMenuQuery(String query) {
        if (!HSMenuItemCompat.isActionViewExpanded(this.searchMenuItem)) {
            HSMenuItemCompat.expandActionView(this.searchMenuItem);
        }
        if (!TextUtils.isEmpty((CharSequence)query)) {
            this.searchView.setQuery((CharSequence)query, false);
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        if (this.isChangingConfigurations() && this.searchMenuItem != null && HSMenuItemCompat.isActionViewExpanded(this.searchMenuItem)) {
            this.presenter.setRetainSearchState(true);
        } else if (this.isDualPane() && !this.isChangingConfigurations()) {
            this.presenter.setRetainSearchState(false);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        int position;
        try {
            position = this.adapter.getMenuItemPosition();
        }
        catch (Exception e) {
            return super.onContextItemSelected(item);
        }
        int i = item.getItemId();
        if (i == R.id.delete_campaign) {
            this.removeItem(position, false);
        } else if (i == R.id.mark_campaign_as_read) {
            this.adapter.markCampaignAsRead(position);
        }
        this.adapter.setMenuItemPosition(-1);
        return super.onContextItemSelected(item);
    }

    public void onContextMenuClosed(Menu menu2) {
        this.adapter.setMenuItemPosition(-1);
    }

    public int getMenuItemPosition() {
        return this.adapter.getMenuItemPosition();
    }

    @Override
    public void onDetach() {
        super.onDetach();
    }

    @Override
    public void dataChanged() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                CampaignListFragment.this.adapter.notifyDataSetChanged();
                CampaignListFragment.this.updateEmptyView();
            }
        });
    }

    @Override
    public void searchActionStarted() {
        this.dismissSnackbar();
    }

    @Override
    public void performedSearch() {
        this.dismissSnackbar();
    }

    @Override
    public void searchActionStopped() {
        this.dismissSnackbar();
    }

    private void dismissSnackbar() {
        if (this.undoSnackbar != null && this.undoSnackbar.isShown()) {
            this.undoSnackbar.dismiss();
        }
    }

    CampaignListFragmentListener getCampaignListFragmentListener() {
        return (CampaignListFragmentListener)this.getParentFragment();
    }
}

