/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.helpshift.R;
import com.helpshift.campaigns.fragments.CampaignDetailFragment;
import com.helpshift.campaigns.fragments.CampaignListFragment;
import com.helpshift.campaigns.fragments.MainFragment;
import com.helpshift.campaigns.listeners.CampaignListFragmentListener;
import com.helpshift.campaigns.util.FragmentUtil;
import com.helpshift.model.InfoModelFactory;

public class InboxFragment
extends MainFragment
implements CampaignListFragmentListener {
    public static final String LAUNCH_SOURCE = "launch_source";
    private boolean showDetailFragment;
    private String detailFragmentCampaignId;
    private Toolbar toolbar;

    public static InboxFragment newInstance(Bundle bundle) {
        InboxFragment campaignFragment = new InboxFragment();
        campaignFragment.setArguments(bundle);
        return campaignFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__campaign_inbox_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.toolbar = (Toolbar)this.getActivity(this).findViewById(R.id.toolbar);
        Bundle arguments = this.getArguments();
        int launchSource = 0;
        if (arguments != null) {
            launchSource = arguments.getInt(LAUNCH_SOURCE, 0);
        }
        if (launchSource == 1 || launchSource == 3) {
            if (this.isDualPane()) {
                this.loadListFragment();
            }
            this.detailFragmentCampaignId = arguments.getString("campaignId");
            this.loadDetailFragment(false);
        } else {
            this.loadListFragment();
            if (this.showDetailFragment) {
                this.loadDetailFragment(true);
            }
        }
        this.updateSelectCampaignView();
        Boolean isDisableHelpshiftBranding = InfoModelFactory.getInstance().appInfoModel.disableHelpshiftBranding;
        if (isDisableHelpshiftBranding != null && isDisableHelpshiftBranding.booleanValue()) {
            ImageView hsLogo = (ImageView)view.findViewById(R.id.hs_logo);
            hsLogo.setVisibility(8);
        }
    }

    private void loadListFragment() {
        Fragment retainedFragment = this.getRetainedChildFragmentManager().findFragmentById(R.id.inbox_fragment_container);
        if (retainedFragment == null) {
            this.showCampaignListFragment();
        } else if (this.isTablet() && !(retainedFragment instanceof CampaignListFragment)) {
            this.onBackPressed();
            this.showCampaignListFragment();
        }
    }

    private void showCampaignListFragment() {
        String tag = CampaignListFragment.class.getName();
        CampaignListFragment campaignListFragment = CampaignListFragment.newInstance();
        FragmentUtil.startFragment(this.getRetainedChildFragmentManager(), R.id.inbox_fragment_container, campaignListFragment, tag, null, false);
    }

    private void loadDetailFragment(boolean addToBackStack) {
        Bundle bundle = new Bundle();
        bundle.putString("campaignId", this.detailFragmentCampaignId);
        String tag = CampaignDetailFragment.class.getName();
        Fragment retainedFragment = this.getRetainedChildFragmentManager().findFragmentByTag(tag);
        if (retainedFragment == null || this.isTablet()) {
            CampaignDetailFragment campaignDetailFragment = CampaignDetailFragment.newInstance(bundle);
            if (this.isDualPane()) {
                FragmentUtil.startFragment(this.getRetainedChildFragmentManager(), R.id.detail_fragment_container, campaignDetailFragment, tag, null, false);
            } else {
                String backstackName = null;
                if (addToBackStack) {
                    backstackName = InboxFragment.class.getName();
                }
                FragmentUtil.startFragment(this.getRetainedChildFragmentManager(), R.id.inbox_fragment_container, campaignDetailFragment, tag, backstackName, false);
            }
        }
    }

    public void onResume() {
        super.onResume();
        this.showToolbarElevation(true);
    }

    public void updateSelectCampaignView() {
        View rootView = this.getView();
        View selectCampaignView = null;
        if (rootView != null) {
            selectCampaignView = rootView.findViewById(R.id.select_campaign_view);
        }
        if (this.isDualPane() && selectCampaignView != null) {
            if (this.showDetailFragment) {
                this.updateSelectCampaignView(false, selectCampaignView);
            } else {
                this.updateSelectCampaignView(true, selectCampaignView);
            }
        }
    }

    public void updateSelectCampaignView(boolean visible, View selectCampaignView) {
        if (selectCampaignView != null) {
            if (visible) {
                selectCampaignView.setVisibility(0);
            } else {
                selectCampaignView.setVisibility(8);
            }
        }
    }

    public void setTitle(String title) {
        if (this.toolbar != null) {
            this.toolbar.setTitle((CharSequence)title);
        } else {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity(this)).getSupportActionBar();
            if (actionBar != null) {
                actionBar.setTitle((CharSequence)title);
            }
        }
    }

    public boolean onBackPressed() {
        FragmentManager fragmentManager = this.getRetainedChildFragmentManager();
        int backStackEntryCount = fragmentManager.getBackStackEntryCount();
        if (backStackEntryCount > 0) {
            fragmentManager.popBackStack();
            return false;
        }
        return true;
    }

    @Override
    public void onCampaignClicked(String campaignId) {
        this.showDetailFragment = true;
        this.detailFragmentCampaignId = campaignId;
        this.loadDetailFragment(true);
        this.updateSelectCampaignView();
    }

    @Override
    public void onCampaignDelete(String campaignId) {
        CampaignDetailFragment fragment;
        if (this.isDualPane() && !TextUtils.isEmpty((CharSequence)campaignId) && campaignId.equals(this.detailFragmentCampaignId) && (fragment = (CampaignDetailFragment)this.getRetainedChildFragmentManager().findFragmentById(R.id.detail_fragment_container)) != null) {
            FragmentUtil.removeFragment(this.getRetainedChildFragmentManager(), fragment);
            this.showDetailFragment = false;
            this.updateSelectCampaignView();
        }
    }

    public void setShowDetailFragment(boolean showDetailFragment) {
        this.showDetailFragment = showDetailFragment;
    }

    public boolean getShowDetailFragment() {
        return this.showDetailFragment;
    }

    public void onContextMenuClosed(Menu menu2) {
        CampaignListFragment campaignListFragment = (CampaignListFragment)this.getRetainedChildFragmentManager().findFragmentById(R.id.inbox_fragment_container);
        if (campaignListFragment != null) {
            campaignListFragment.onContextMenuClosed(menu2);
        }
    }

    public static class LaunchSource {
        public static final int PUSH = 1;
        public static final int APP_INBOX = 2;
        public static final int APP_SINGLE_MESSAGE = 3;
    }
}

