/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.fragments;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import com.helpshift.R;
import com.helpshift.campaigns.fragments.InboxFragment;
import com.helpshift.campaigns.util.FragmentUtil;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.Styles;
import java.lang.reflect.Field;
import java.util.ArrayList;

public abstract class MainFragment
extends Fragment {
    public static final String TOOLBAR_ID = "toolbarId";
    private int toolbarId = 0;
    private Toolbar toolbar = null;
    private boolean isChangingConfigurations;
    private boolean isDualPane;
    private FragmentManager retainedChildFragmentManager;
    private static boolean shouldRetainChildFragmentManager;

    public FragmentManager getRetainedChildFragmentManager() {
        if (shouldRetainChildFragmentManager) {
            if (this.retainedChildFragmentManager == null) {
                this.retainedChildFragmentManager = this.getChildFragmentManager();
            }
            return this.retainedChildFragmentManager;
        }
        return this.getChildFragmentManager();
    }

    public boolean isChangingConfigurations() {
        return this.isChangingConfigurations;
    }

    public Context getContext() {
        Context context = super.getContext();
        if (context != null) {
            return context;
        }
        return HelpshiftContext.getApplicationContext();
    }

    protected boolean shouldRetainInstance() {
        return true;
    }

    public void onAttach(Context context) {
        super.onAttach(ApplicationUtil.getContextWithUpdatedLocaleLegacy(context));
        if (this.shouldRetainInstance()) {
            try {
                this.setRetainInstance(true);
            }
            catch (Exception e) {
                shouldRetainChildFragmentManager = true;
            }
        }
        if (HelpshiftContext.getApplicationContext() == null) {
            HelpshiftContext.setApplicationContext(context.getApplicationContext());
        }
        this.isDualPane = this.getResources().getBoolean(R.bool.is_dual_pane);
        if (shouldRetainChildFragmentManager && this.retainedChildFragmentManager != null) {
            try {
                Field childFMField = Fragment.class.getDeclaredField("mChildFragmentManager");
                childFMField.setAccessible(true);
                childFMField.set((Object)this, this.retainedChildFragmentManager);
            }
            catch (NoSuchFieldException e) {
                HSLogger.d("MainFragment", "NoSuchFieldException", e);
            }
            catch (IllegalAccessException e) {
                HSLogger.d("MainFragment", "IllegalAccessException", e);
            }
        }
    }

    protected boolean isTablet() {
        return this.getResources().getBoolean(R.bool.is_screen_large);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.toolbarId = bundle.getInt(TOOLBAR_ID);
        }
        if (this.toolbarId == 0 && this.getMenuResourceId() != 0) {
            this.setHasOptionsMenu(true);
        }
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.toolbarId != 0 && this.getMenuResourceId() != 0) {
            this.toolbar = (Toolbar)this.getActivity().findViewById(this.toolbarId);
            Menu parentMenu = this.toolbar.getMenu();
            ArrayList<Integer> parentMenuItems = new ArrayList<Integer>();
            for (int i = 0; i < parentMenu.size(); ++i) {
                parentMenuItems.add(parentMenu.getItem(i).getItemId());
            }
            this.toolbar.inflateMenu(this.getMenuResourceId());
            this.attachMenuListeners(this.toolbar.getMenu());
        }
    }

    public void onStop() {
        super.onStop();
        if (Build.VERSION.SDK_INT >= 11) {
            this.isChangingConfigurations = this.getActivity(this).isChangingConfigurations();
        }
    }

    public void onDetach() {
        ApplicationUtil.restoreApplicationLocale();
        super.onDetach();
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(this.getMenuResourceId(), menu2);
        this.attachMenuListeners(menu2);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    protected Bundle getBundle() {
        Bundle bundle = new Bundle();
        if (this.toolbarId != 0) {
            bundle.putInt(TOOLBAR_ID, this.toolbarId);
        }
        return bundle;
    }

    protected int getMenuResourceId() {
        return 0;
    }

    protected void attachMenuListeners(Menu menu2) {
    }

    public Activity getActivity(Fragment fragment) {
        if (fragment == null) {
            return null;
        }
        while (fragment.getParentFragment() != null) {
            fragment = fragment.getParentFragment();
        }
        return fragment.getActivity();
    }

    public boolean isDualPane() {
        return this.isDualPane && this.isTablet();
    }

    public void setToolbarTitle(String title) {
        if (this instanceof InboxFragment) {
            ((InboxFragment)this).setTitle(title);
        } else {
            InboxFragment inboxFragment = FragmentUtil.getInboxFragment(this);
            if (inboxFragment != null) {
                inboxFragment.setTitle(title);
            }
        }
    }

    public void showToolbarElevation(boolean visible) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.showToolbarElevationLollipop(visible);
        }
    }

    @TargetApi(value=21)
    private void showToolbarElevationLollipop(boolean visible) {
        if (this.toolbar != null) {
            if (visible) {
                this.toolbar.setElevation(Styles.dpToPx(this.getContext(), 4.0f));
            } else {
                this.toolbar.setElevation(0.0f);
            }
        } else {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity(this)).getSupportActionBar();
            if (actionBar != null) {
                if (visible) {
                    actionBar.setElevation(Styles.dpToPx(this.getContext(), 4.0f));
                } else {
                    actionBar.setElevation(0.0f);
                }
            }
        }
    }
}

