/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.interactors;

import android.app.Activity;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.observers.CampaignDetailObserver;
import com.helpshift.campaigns.observers.CampaignStorageObserver;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.campaigns.storage.CampaignSyncModelStorage;
import java.util.ArrayList;
import java.util.List;

public class CampaignDetailInteractor
implements CampaignStorageObserver {
    private CampaignStorage storage;
    private String campaignId;
    private List<CampaignDetailObserver> observers;
    private CampaignDetailModel campaignDetailModel;

    private CampaignDetailInteractor(String campaignId, CampaignStorage campaignStorage) {
        this.storage = campaignStorage;
        this.campaignId = campaignId;
        this.campaignDetailModel = this.storage.getCampaign(campaignId);
        this.observers = new ArrayList<CampaignDetailObserver>();
    }

    public static CampaignDetailInteractor newInstance(String campaignId, CampaignStorage campaignStorage, CampaignSyncModelStorage syncModelStorage) {
        boolean isValidCampaignId;
        CampaignDetailInteractor newCampaignDetailInteractor = null;
        boolean bl = isValidCampaignId = campaignStorage.getCampaign(campaignId) != null || syncModelStorage.getCampaign(campaignId, ControllerFactory.getInstance().userController.getCurrentUser().identifier) != null;
        if (isValidCampaignId) {
            newCampaignDetailInteractor = new CampaignDetailInteractor(campaignId, campaignStorage);
        }
        return newCampaignDetailInteractor;
    }

    public void markCampaignAsSeen() {
        this.storage.markCampaignAsSeen(this.campaignId);
        ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.VIEW, this.campaignId, false);
    }

    public void executeAction(int index, Activity activity) {
        this.campaignDetailModel.executeAction(index, activity);
    }

    public CampaignDetailModel getCampaignDetailModel() {
        return this.campaignDetailModel;
    }

    @Override
    public void campaignDetailModelAdded(CampaignDetailModel campaignDetailModel) {
        if (campaignDetailModel.getIdentifier().equals(this.campaignId)) {
            this.campaignDetailModel = this.storage.getCampaign(this.campaignId);
            for (CampaignDetailObserver observer : this.observers) {
                observer.campaignDetailAdded();
            }
        }
    }

    @Override
    public void campaignIconImageFilePathUpdated(String campaignId) {
        if (campaignId.equals(this.campaignId)) {
            this.campaignDetailModel = this.storage.getCampaign(campaignId);
            for (CampaignDetailObserver observer : this.observers) {
                observer.campaignIconImageDownloaded();
            }
        }
    }

    @Override
    public void campaignCoverImageFilePathUpdated(String campaignId) {
        if (campaignId.equals(this.campaignId)) {
            this.campaignDetailModel = this.storage.getCampaign(campaignId);
            for (CampaignDetailObserver observer : this.observers) {
                observer.campaignCoverImageDownloaded();
            }
        }
    }

    @Override
    public void campaignDeleted(String campaignId) {
    }

    @Override
    public void campaignRead(String campaignId) {
    }

    @Override
    public void campaignSeen(String campaignId) {
    }

    public void addObserver(CampaignDetailObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(CampaignDetailObserver observer) {
        this.observers.remove(observer);
    }

    public void setUp() {
        this.storage.addObserver(this);
    }

    public void cleanUp() {
        this.storage.removeObserver(this);
    }
}

