/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.interactors;

import android.text.TextUtils;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.observers.CampaignListObserver;
import com.helpshift.campaigns.observers.CampaignStorageObserver;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.campaigns.util.InAppCampaignsUtil;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.List;

public class CampaignsListInteractor
implements CampaignStorageObserver {
    private static final String TAG = "Helpshift_CampListInt";
    private CampaignStorage campaignStorage;
    private List<CampaignDetailModel> campaignsToShow;
    private List<CampaignDetailModel> allCampaigns;
    private boolean searchStarted = false;
    private CampaignListObserver observer;
    private CampaignDetailModel campaignToUndoDelete;
    private int undoPosition;

    public CampaignsListInteractor(CampaignStorage campaignStorage) {
        this.campaignStorage = campaignStorage;
        this.allCampaigns = this.getAllActiveCampaigns();
        this.campaignsToShow = this.allCampaigns;
        HSLogger.d(TAG, "Campaigns to show : " + (this.campaignsToShow == null ? 0 : this.campaignsToShow.size()));
    }

    public CampaignDetailModel getCampaign(int index) {
        if (this.campaignsToShow != null && index < this.campaignsToShow.size() && index >= 0) {
            return this.campaignsToShow.get(index);
        }
        return null;
    }

    public int getCountOfCampaigns() {
        if (this.campaignsToShow != null) {
            return this.campaignsToShow.size();
        }
        return 0;
    }

    private List<CampaignDetailModel> getAllActiveCampaigns() {
        return InAppCampaignsUtil.cleanAndGetActiveCampaigns(this.campaignStorage, ControllerFactory.getInstance().userController.getCurrentUser().identifier);
    }

    private boolean removeCampaignFromUi(String campaignId) {
        boolean isDeleted = false;
        if (!TextUtils.isEmpty((CharSequence)campaignId) && this.campaignsToShow != null) {
            CampaignDetailModel campaignToRemove = null;
            for (CampaignDetailModel campaign : this.campaignsToShow) {
                if (!campaign.getIdentifier().equals(campaignId)) continue;
                campaignToRemove = campaign;
                break;
            }
            if (campaignToRemove != null) {
                this.undoPosition = this.campaignsToShow.indexOf(campaignToRemove);
                this.campaignToUndoDelete = campaignToRemove;
                this.campaignsToShow.remove(campaignToRemove);
                ApplicationUtil.cancelNotification(campaignId);
                isDeleted = true;
            }
        }
        return isDeleted;
    }

    private void deleteCampaignFromStorage() {
        if (this.campaignToUndoDelete != null) {
            String campaignId = this.campaignToUndoDelete.getIdentifier();
            this.campaignStorage.deleteCampaign(campaignId);
            ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.MARK_AS_DELETE, campaignId, false);
            if (this.searchStarted) {
                this.allCampaigns.remove(this.campaignToUndoDelete);
            }
            this.campaignToUndoDelete = null;
        }
    }

    public void deleteCampaign(String campaignId, boolean undo) {
        if (this.campaignToUndoDelete != null) {
            this.deleteCampaignFromStorage();
        }
        this.removeCampaignFromUi(campaignId);
        if (!undo) {
            this.deleteCampaignFromStorage();
        }
    }

    public void undoTimedOut() {
        this.deleteCampaignFromStorage();
    }

    public void undoDeletedCampaign() {
        if (this.campaignToUndoDelete != null) {
            this.campaignsToShow.add(this.undoPosition, this.campaignToUndoDelete);
            this.campaignToUndoDelete = null;
        }
    }

    public void markCampaignAsRead(String campaignId) {
        if (!TextUtils.isEmpty((CharSequence)campaignId)) {
            this.campaignStorage.markCampaignAsRead(campaignId);
            if (this.campaignsToShow != null) {
                for (CampaignDetailModel campaign : this.campaignsToShow) {
                    if (!campaign.getIdentifier().equals(campaignId)) continue;
                    campaign.setReadStatus(true);
                    ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.MARK_AS_READ, campaign.getIdentifier(), false);
                    break;
                }
            }
        }
    }

    public void performSearch(String query) {
        if (this.campaignToUndoDelete != null) {
            this.undoTimedOut();
        }
        if (!TextUtils.isEmpty((CharSequence)query) && query.length() > 2 && this.allCampaigns != null) {
            ArrayList<CampaignDetailModel> searchResults = new ArrayList<CampaignDetailModel>();
            block0: for (CampaignDetailModel campaign : this.allCampaigns) {
                String queryLowerCase = query.toLowerCase().trim();
                String[] queryWords = queryLowerCase.split("\\s+");
                String campaignTitle = campaign.getTitle();
                String campaignBody = campaign.getBody();
                for (String word : queryWords) {
                    if ((campaignBody == null || !campaignBody.toLowerCase().contains(word)) && (campaignTitle == null || !campaignTitle.toLowerCase().contains(word))) continue;
                    searchResults.add(campaign);
                    continue block0;
                }
            }
            this.campaignsToShow = searchResults;
        } else {
            this.campaignsToShow = this.allCampaigns;
        }
        if (this.observer != null) {
            this.observer.searchResultsUpdated();
        }
    }

    public void searchActionStarted() {
        if (this.campaignToUndoDelete != null) {
            this.undoTimedOut();
        }
        this.searchStarted = true;
    }

    public void searchActionStopped() {
        this.searchStarted = false;
        if (this.campaignToUndoDelete != null) {
            this.undoTimedOut();
        }
        this.allCampaigns = this.getAllActiveCampaigns();
        this.campaignsToShow = this.allCampaigns;
    }

    public void cleanUpExpiredCampaigns() {
        this.allCampaigns = this.getAllActiveCampaigns();
        if (!this.searchStarted) {
            this.campaignsToShow = this.allCampaigns;
        }
    }

    @Override
    public void campaignDetailModelAdded(CampaignDetailModel campaignDetailModel) {
        this.allCampaigns = this.getAllActiveCampaigns();
        if (!this.searchStarted) {
            this.campaignsToShow = this.allCampaigns;
        }
        if (this.observer != null) {
            this.observer.campaignAdded();
        }
    }

    @Override
    public void campaignIconImageFilePathUpdated(String campaignId) {
        if (this.allCampaigns != null) {
            int campaignIndexToUpdate = -1;
            boolean updateCampaign = false;
            for (CampaignDetailModel campaign : this.allCampaigns) {
                ++campaignIndexToUpdate;
                if (!campaign.getIdentifier().equals(campaignId)) continue;
                updateCampaign = true;
                break;
            }
            if (campaignIndexToUpdate >= 0 && campaignIndexToUpdate < this.allCampaigns.size() && updateCampaign) {
                this.allCampaigns.set(campaignIndexToUpdate, this.campaignStorage.getCampaign(campaignId));
            }
            if (this.observer != null) {
                this.observer.campaignIconImageDownloaded();
            }
        }
    }

    @Override
    public void campaignCoverImageFilePathUpdated(String campaignId) {
    }

    @Override
    public void campaignDeleted(String campaignId) {
    }

    @Override
    public void campaignRead(String campaignId) {
    }

    @Override
    public void campaignSeen(String campaignId) {
        if (!TextUtils.isEmpty((CharSequence)campaignId) && this.campaignsToShow != null) {
            for (CampaignDetailModel campaign : this.campaignsToShow) {
                if (!campaign.getIdentifier().equals(campaignId)) continue;
                campaign.setSeenStatus(true);
                if (this.observer == null) break;
                this.observer.campaignMarkedAsSeen();
                break;
            }
        }
    }

    public void setObserver(CampaignListObserver observer) {
        this.observer = observer;
    }

    public void setUp() {
        this.campaignStorage.addObserver(this);
    }

    public void cleanUp() {
        this.campaignStorage.removeObserver(this);
    }
}

