/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.app.Activity;
import com.helpshift.CoreInternal;
import com.helpshift.enums.ACTION_TYPE;
import com.helpshift.executors.ActionExecutor;
import com.helpshift.util.HSLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionModel
implements Serializable {
    private static final String TAG = ActionModel.class.getSimpleName();
    private String actionId;
    public String title;
    public ACTION_TYPE actionType;
    public String actionData;
    public String textColor;
    public boolean isGoalCompletion;
    private ActionExecutor actionExecutor;
    private static final long serialVersionUID = 1L;

    ActionModel(JSONObject actionObject) {
        try {
            this.actionId = actionObject.getString("id");
            this.title = actionObject.getString("t");
            this.actionType = ACTION_TYPE.getEnum(actionObject.getInt("a"));
            this.actionData = actionObject.optString("d", "");
            this.textColor = actionObject.getString("c");
            this.isGoalCompletion = actionObject.getBoolean("g");
            this.actionExecutor = CoreInternal.getActionExecutor();
        }
        catch (JSONException e) {
            HSLogger.d(TAG, "Exception while creating actionType object from json : ", e);
        }
    }

    public void executeAction(Activity activity) {
        if (this.actionExecutor != null) {
            this.actionExecutor.executeAction(activity, this.actionType, this.actionData);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.actionId);
        out.writeUTF(this.title);
        out.writeObject((Object)this.actionType);
        out.writeUTF(this.actionData);
        out.writeUTF(this.textColor);
        out.writeBoolean(this.isGoalCompletion);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.actionData = in.readUTF();
        this.title = in.readUTF();
        this.actionType = (ACTION_TYPE)((Object)in.readObject());
        this.actionData = in.readUTF();
        this.textColor = in.readUTF();
        this.isGoalCompletion = in.readBoolean();
    }

    public boolean equals(Object otherObj) {
        boolean isEqual = false;
        if (otherObj instanceof ActionModel) {
            ActionModel other = (ActionModel)otherObj;
            boolean bl = isEqual = this.actionId.equals(other.actionId) && this.title.equals(other.title) && this.actionType == other.actionType && this.actionData.equals(other.actionData) && this.textColor.equals(other.textColor) && this.isGoalCompletion == other.isGoalCompletion;
            isEqual = this.actionExecutor != null ? isEqual && other.actionExecutor != null && this.actionExecutor.getClass().getName().equals(other.actionExecutor.getClass().getName()) : isEqual && other.actionExecutor == null;
        }
        return isEqual;
    }
}

