/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.text.TextUtils;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.model.InfoModelFactory;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class AnalyticsEvent
implements Serializable {
    public String eventId;
    public String campaignId;
    public Long timeStamp;
    public String userId;
    public Integer type;
    public Boolean goalCompletion;
    private static final long serialVersionUID = 8930869772164604416L;

    public AnalyticsEvent(Integer type, String campaignId, Boolean goalCompletion) {
        long now = System.currentTimeMillis();
        this.eventId = "__hs_ae_" + campaignId + "_" + now;
        this.campaignId = campaignId;
        this.timeStamp = now;
        this.userId = ControllerFactory.getInstance().userController.getCurrentUser().identifier;
        this.type = type;
        this.goalCompletion = goalCompletion;
    }

    public HashMap toData() {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        String changeSetId = InfoModelFactory.getInstance().sdkInfoModel.getChangeSetId(this.campaignId);
        if (TextUtils.isEmpty((CharSequence)changeSetId)) {
            changeSetId = this.campaignId;
        }
        eventData.put("cid", changeSetId);
        eventData.put("uid", this.userId);
        eventData.put("ts", this.timeStamp);
        eventData.put("t", this.type);
        eventData.put("g", this.goalCompletion);
        eventData.put("v", 1);
        return eventData;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.eventId);
        out.writeUTF(this.campaignId);
        out.writeLong(this.timeStamp);
        out.writeUTF(this.userId);
        out.writeInt(this.type);
        out.writeBoolean(this.goalCompletion);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.eventId = in.readUTF();
        this.campaignId = in.readUTF();
        this.timeStamp = in.readLong();
        this.userId = in.readUTF();
        this.type = in.readInt();
        try {
            this.goalCompletion = in.readBoolean();
        }
        catch (EOFException e) {
            this.goalCompletion = false;
        }
    }

    public static class AnalyticsEventType {
        public static final Integer DEFAULT = 0;
        public static final Integer DELIVERY = 1;
        public static final Integer VIEW = 2;
        public static final Integer MARK_AS_READ = 5;
        public static final Integer MARK_AS_DELETE = 6;
        public static final Integer DELETE_EXPIRED_MESSAGE = 8;
        static final Integer[] BUTTON_EVENTS = new Integer[]{201, 202, 203, 204};
    }
}

