/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.helpshift.campaigns.models.Device;
import com.helpshift.network.util.IpUtil;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.LocaleUtil;
import com.helpshift.util.TextUtils;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.TimeZone;

public class AndroidDevice
implements Device {
    private static final String TAG = "Helpshift_AndroidDevice";

    @Override
    public String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    @Override
    public String getBuildModel() {
        return Build.MODEL;
    }

    @Override
    public String getAppVersion() {
        return ApplicationUtil.getApplicationVersion(HelpshiftContext.getApplicationContext());
    }

    @Override
    public String getCountryCode() {
        String localeCountry;
        Context context = HelpshiftContext.getApplicationContext();
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String countryCode = "";
        if (tm.getPhoneType() != 2) {
            countryCode = tm.getNetworkCountryIso();
        }
        if (TextUtils.isEmpty(countryCode)) {
            countryCode = tm.getSimCountryIso();
        }
        if (TextUtils.isEmpty(countryCode) && (localeCountry = LocaleUtil.getCountry(context)) != null) {
            countryCode = localeCountry.toLowerCase();
        }
        return countryCode;
    }

    @Override
    public String getLanguageCode() {
        String languageCode = null;
        try {
            languageCode = Locale.getDefault().toString();
        }
        catch (MissingResourceException e) {
            HSLogger.d(TAG, "Device Info - MissingResourceException", e);
        }
        return languageCode;
    }

    @Override
    public String getCarrierName() {
        Context context = HelpshiftContext.getApplicationContext();
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getNetworkOperatorName();
    }

    @Override
    public Integer getTimeZone() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getOffset(System.currentTimeMillis()) / 60000;
    }

    @Override
    public String getIpAddress() {
        return IpUtil.getIPAddress(true);
    }
}

