/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.app.Activity;
import android.graphics.Bitmap;
import android.text.TextUtils;
import com.helpshift.R;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.ActionModel;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.campaigns.models.InboxMessage;
import com.helpshift.enums.ACTION_TYPE;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.ImageUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CampaignDetailModel
implements InboxMessage {
    private static final String TAG = "Helpshift_CampDetailMod";
    private String identifier;
    public String userIdentifier;
    private String title;
    private String body;
    public String coverImageUrl;
    public String iconImageUrl;
    public String coverImageFilePath;
    public String iconImageFilePath;
    private String backgroundColor;
    private String titleColor;
    private String bodyColor;
    private boolean readStatus;
    private boolean seenStatus;
    private long createdAt;
    private long expiryTimeStamp;
    public List<ActionModel> actions;
    public List<String> messages;

    public CampaignDetailModel(String campaignId, JSONObject campaignDetailObject, long ts, long expiryTimeStamp) {
        try {
            this.identifier = campaignId;
            this.createdAt = ts;
            this.expiryTimeStamp = expiryTimeStamp;
            this.userIdentifier = ControllerFactory.getInstance().userController.getCurrentUser().identifier;
            this.title = campaignDetailObject.getString("t");
            this.body = campaignDetailObject.getString("m");
            this.coverImageUrl = campaignDetailObject.optString("ci", "");
            this.iconImageUrl = campaignDetailObject.optString("ic", "");
            JSONObject styleSheet = campaignDetailObject.getJSONObject("ss");
            this.backgroundColor = styleSheet.getString("bg");
            this.titleColor = styleSheet.getString("tc");
            this.bodyColor = styleSheet.getString("mc");
            ArrayList<ActionModel> actionList = new ArrayList<ActionModel>();
            JSONArray actions = campaignDetailObject.optJSONArray("bs");
            for (int i = 0; i < actions.length(); ++i) {
                actionList.add(new ActionModel(actions.getJSONObject(i)));
            }
            this.actions = actionList;
        }
        catch (JSONException e) {
            HSLogger.d(TAG, "Exception while creating Campaign Detail Object : ", e);
        }
    }

    public CampaignDetailModel(String identifier, String userIdentifier, String title, String body, String coverImageUrl, String coverImageFilePath, String iconImageUrl, String iconImageFilePath, String backgroundColor, String titleColor, String bodyColor, boolean readStatus, boolean seenStatus, long createdAt, long expiryTimeStamp, List<ActionModel> actions, List<String> messages) {
        this.identifier = identifier;
        this.userIdentifier = userIdentifier;
        this.title = title;
        this.body = body;
        this.coverImageUrl = coverImageUrl;
        this.coverImageFilePath = coverImageFilePath;
        this.iconImageUrl = iconImageUrl;
        this.iconImageFilePath = iconImageFilePath;
        this.backgroundColor = backgroundColor;
        this.titleColor = titleColor;
        this.bodyColor = bodyColor;
        this.readStatus = readStatus;
        this.seenStatus = seenStatus;
        this.actions = actions;
        this.messages = messages;
        this.createdAt = createdAt;
        this.expiryTimeStamp = expiryTimeStamp;
    }

    @Override
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getExpiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public boolean isExpired() {
        return this.expiryTimeStamp != Long.MAX_VALUE && System.currentTimeMillis() / 1000L > this.expiryTimeStamp;
    }

    @Override
    public boolean getSeenStatus() {
        return this.seenStatus;
    }

    public void setSeenStatus(boolean seenStatus) {
        this.seenStatus = seenStatus;
    }

    @Override
    public boolean getReadStatus() {
        return this.readStatus;
    }

    public void setReadStatus(boolean readStatus) {
        this.readStatus = readStatus;
    }

    @Override
    public String getBodyColor() {
        return this.bodyColor;
    }

    @Override
    public String getTitleColor() {
        return this.titleColor;
    }

    @Override
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Bitmap getCoverImage() {
        Bitmap imageBitmap = ImageUtil.getBitmap(this.coverImageFilePath, -1);
        if (imageBitmap == null && !TextUtils.isEmpty((CharSequence)this.coverImageUrl)) {
            File file;
            if (this.coverImageFilePath != null && (file = new File(this.coverImageFilePath)).exists()) {
                file.delete();
            }
            ControllerFactory.getInstance().inboxSyncController.startCoverImageDownload(this.coverImageUrl, this.identifier);
        }
        return imageBitmap;
    }

    @Override
    public Bitmap getIconImage() {
        Bitmap iconImageBitmap = ImageUtil.getBitmap(this.iconImageFilePath, -1);
        if (iconImageBitmap == null) {
            iconImageBitmap = ImageUtil.getBitmap(HelpshiftContext.getApplicationContext().getResources(), R.drawable.hs__cam_inbox_default_icon, -1);
            if (!TextUtils.isEmpty((CharSequence)this.iconImageUrl)) {
                File file;
                if (this.iconImageFilePath != null && (file = new File(this.iconImageFilePath)).exists()) {
                    file.delete();
                }
                ControllerFactory.getInstance().inboxSyncController.startIconImageDownload(this.iconImageUrl, this.identifier);
            }
        }
        return iconImageBitmap;
    }

    @Override
    public int getCountOfActions() {
        if (this.actions != null) {
            return this.actions.size();
        }
        return 0;
    }

    @Override
    public String getActionTitle(int index) {
        String actionTitle = null;
        if (this.actions != null && index >= 0 && index < this.actions.size()) {
            actionTitle = this.actions.get((int)index).title;
        }
        return actionTitle;
    }

    @Override
    public String getActionTitleColor(int index) {
        String actionTitleColor = null;
        if (this.actions != null && index >= 0 && index < this.actions.size()) {
            actionTitleColor = this.actions.get((int)index).textColor;
        }
        return actionTitleColor;
    }

    @Override
    public boolean isActionGoalCompletion(int index) {
        boolean isGoalCompletion = false;
        if (this.actions != null && index >= 0 && index < this.actions.size()) {
            isGoalCompletion = this.actions.get((int)index).isGoalCompletion;
        }
        return isGoalCompletion;
    }

    @Override
    public void executeAction(int index, Activity activity) {
        if (this.actions != null && index >= 0 && index < this.actions.size()) {
            ActionModel action = this.actions.get(index);
            action.executeAction(activity);
            ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.BUTTON_EVENTS[index], this.getIdentifier(), action.isGoalCompletion);
        }
    }

    @Override
    public InboxMessage.INBOX_MESSAGE_ACTION_TYPE getActionType(int index) {
        if (this.actions != null && index >= 0 && index < this.actions.size()) {
            ACTION_TYPE messageActionType = this.actions.get((int)index).actionType;
            switch (messageActionType) {
                case OPEN_DEEP_LINK: {
                    return InboxMessage.INBOX_MESSAGE_ACTION_TYPE.OPEN_DEEP_LINK;
                }
                case SHOW_FAQS: {
                    return InboxMessage.INBOX_MESSAGE_ACTION_TYPE.SHOW_FAQS;
                }
                case SHOW_FAQ_SECTION: {
                    return InboxMessage.INBOX_MESSAGE_ACTION_TYPE.SHOW_FAQ_SECTION;
                }
                case SHOW_CONVERSATION: {
                    return InboxMessage.INBOX_MESSAGE_ACTION_TYPE.SHOW_CONVERSATION;
                }
                case SHOW_SINGLE_FAQ: {
                    return InboxMessage.INBOX_MESSAGE_ACTION_TYPE.SHOW_SINGLE_FAQ;
                }
                case SHOW_ALERT_TO_RATE_APP: {
                    return InboxMessage.INBOX_MESSAGE_ACTION_TYPE.SHOW_ALERT_TO_RATE_APP;
                }
            }
            return InboxMessage.INBOX_MESSAGE_ACTION_TYPE.UNKNOWN;
        }
        return InboxMessage.INBOX_MESSAGE_ACTION_TYPE.UNKNOWN;
    }

    @Override
    public String getActionData(int index) {
        if (this.actions != null && index >= 0 && index < this.actions.size()) {
            return this.actions.get((int)index).actionData;
        }
        return null;
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof CampaignDetailModel) {
            boolean isEqual;
            CampaignDetailModel other = (CampaignDetailModel)otherObj;
            boolean bl = isEqual = this.identifier.equals(other.identifier) && this.userIdentifier.equals(other.userIdentifier) && this.title.equals(other.title) && this.body.equals(other.body) && this.iconImageUrl.equals(other.iconImageUrl) && this.backgroundColor.equals(other.backgroundColor) && this.titleColor.equals(other.titleColor) && this.bodyColor.equals(other.bodyColor) && this.readStatus == other.readStatus && this.seenStatus == other.seenStatus && this.createdAt == other.createdAt && this.expiryTimeStamp == other.expiryTimeStamp;
            if (this.iconImageFilePath != null) {
                isEqual = isEqual && this.iconImageFilePath.equals(other.iconImageFilePath);
            } else {
                boolean bl2 = isEqual = isEqual && other.iconImageFilePath == null;
            }
            if (this.coverImageUrl != null) {
                isEqual = isEqual && this.coverImageUrl.equals(other.coverImageUrl);
            } else {
                boolean bl3 = isEqual = isEqual && other.coverImageUrl == null;
            }
            if (this.coverImageFilePath != null) {
                isEqual = isEqual && this.coverImageFilePath.equals(other.coverImageFilePath);
            } else {
                boolean bl4 = isEqual = isEqual && other.coverImageFilePath == null;
            }
            if (this.actions != null) {
                isEqual = isEqual && this.actions.equals(other.actions);
            } else {
                boolean bl5 = isEqual = isEqual && other.actions == null;
            }
            isEqual = this.messages != null ? isEqual && this.messages.equals(other.messages) : isEqual && other.messages == null;
            return isEqual;
        }
        return false;
    }
}

