/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import com.helpshift.util.HSLogger;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class CampaignSyncModel
implements Serializable {
    private static final String TAG = "Helpshift_CampSyncMod";
    public String campaignId;
    public String creativeUrl;
    public long timeStamp;
    private boolean isSyncing;
    public long expiryTimeStamp = Long.MAX_VALUE;
    private static final long serialVersionUID = 2L;

    public CampaignSyncModel(String campaignId, String creativeUrl, long timeStamp, long expiryTimeStamp, boolean isSyncing) {
        this.campaignId = campaignId;
        this.creativeUrl = creativeUrl;
        this.timeStamp = timeStamp;
        this.expiryTimeStamp = expiryTimeStamp;
        this.isSyncing = isSyncing;
    }

    public CampaignSyncModel(JSONObject campaignSyncModelObject) {
        try {
            this.campaignId = campaignSyncModelObject.getString("cid");
            this.creativeUrl = campaignSyncModelObject.getString("creative-url");
            this.timeStamp = campaignSyncModelObject.getLong("ts");
            this.expiryTimeStamp = campaignSyncModelObject.optLong("expires", Long.MAX_VALUE);
            this.isSyncing = false;
        }
        catch (JSONException e) {
            HSLogger.d(TAG, "Exception in initializing model with json object : ", e);
        }
    }

    public boolean isSyncing() {
        return this.isSyncing;
    }

    public void setIsSyncing(boolean isSynced) {
        this.isSyncing = isSynced;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.campaignId);
        out.writeUTF(this.creativeUrl);
        out.writeLong(this.timeStamp);
        out.writeBoolean(this.isSyncing);
        out.writeLong(this.expiryTimeStamp);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.campaignId = in.readUTF();
        this.creativeUrl = in.readUTF();
        this.timeStamp = in.readLong();
        this.isSyncing = in.readBoolean();
        try {
            this.expiryTimeStamp = in.readLong();
        }
        catch (EOFException e) {
            this.expiryTimeStamp = Long.MAX_VALUE;
        }
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof CampaignSyncModel) {
            CampaignSyncModel other = (CampaignSyncModel)otherObj;
            return this.isSyncing == other.isSyncing && this.campaignId.equals(other.campaignId) && this.creativeUrl.equals(other.creativeUrl) && this.timeStamp == other.timeStamp && this.expiryTimeStamp == other.expiryTimeStamp;
        }
        return false;
    }
}

