/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.helpshift.campaigns.models.Device;
import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.util.constants.DeviceProperties;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.LocationUtil;
import com.helpshift.util.concurrent.DispatchQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class DeviceModel {
    private static final String TAG = "Helpshift_DeviceModel";
    PropertyValue[] properties = new PropertyValue[13];
    protected final String[] deviceKeys = new String[]{"os", "av", "dp", "np", "dm", "cc", "ln", "ip", "tz", "ll", "ca", "pt", "sv"};
    String identifier;
    PropertyStorage storage;
    DispatchQueue workerQueue;
    Device device;

    public DeviceModel(Device device, PropertyStorage storage, DispatchQueue dispatchQueue) {
        int platformIndex;
        String deviceId = InfoModelFactory.getInstance().sdkInfoModel.getDeviceId();
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = UUID.randomUUID().toString();
            InfoModelFactory.getInstance().sdkInfoModel.addDeviceId(deviceId);
        }
        this.identifier = deviceId;
        this.storage = storage;
        this.storage.initSecondaryStorage(this.identifier);
        this.device = device;
        HashMap<String, PropertyValue> properties = storage.getAllSecondaryProperties(deviceId);
        if (properties != null) {
            for (int i = 0; i < 13; ++i) {
                this.properties[i] = properties.get(this.deviceKeys[i]);
            }
        }
        if (this.properties[platformIndex = DeviceProperties.DeviceKeys.PLATFORM.intValue()] == null) {
            this.properties[platformIndex] = new PropertyValue("android");
            this.storage.setSecondaryProperty(this.deviceKeys[platformIndex], this.properties[platformIndex], deviceId);
        }
        this.workerQueue = dispatchQueue;
        this.rescanDevice();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    <T> void setProperty(Integer key, T newValue) {
        if (newValue != null) {
            PropertyValue value = this.properties[key];
            boolean propertyChanged = false;
            if (value != null && value.setValue(newValue)) {
                propertyChanged = true;
            } else if (value == null) {
                value = new PropertyValue(newValue);
                boolean bl = propertyChanged = !value.getType().equals("u");
            }
            if (propertyChanged) {
                this.properties[key.intValue()] = value;
                this.storage.setSecondaryProperty(this.deviceKeys[key], value, this.identifier);
                if (this.shouldDevicePropertySyncImmediately(key)) {
                    InfoModelFactory.getInstance().sdkInfoModel.setDevicePropertiesSyncImmediately(true);
                }
            }
        }
    }

    public Object getPropertyValue(final Integer key) {
        final Object[] propertyValue = new Object[]{null};
        this.workerQueue.dispatchSync(new Runnable(){

            @Override
            public void run() {
                String deviceKey = DeviceModel.this.deviceKeys[key];
                PropertyValue property = DeviceModel.this.storage.getSecondaryProperty(deviceKey, DeviceModel.this.identifier);
                if (property != null) {
                    propertyValue[0] = property.getValue();
                }
            }
        });
        return propertyValue[0];
    }

    public void rescanDevice() {
        final DeviceModel model = this;
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                model.setProperty(DeviceProperties.DeviceKeys.OS, model.device.getOsVersion());
                model.setProperty(DeviceProperties.DeviceKeys.MODEL, model.device.getBuildModel());
                model.setProperty(DeviceProperties.DeviceKeys.APP_VERSION, model.device.getAppVersion());
                model.setProperty(DeviceProperties.DeviceKeys.LANGUAGE, model.device.getLanguageCode());
                model.setProperty(DeviceProperties.DeviceKeys.CARRIER, model.device.getCarrierName());
                model.setProperty(DeviceProperties.DeviceKeys.IP, model.device.getIpAddress());
                model.setProperty(DeviceProperties.DeviceKeys.TIMEZONE, model.device.getTimeZone());
                model.setProperty(DeviceProperties.DeviceKeys.SDK_VERSION, "6.3.0");
                Context context = HelpshiftContext.getApplicationContext();
                if (ApplicationUtil.isPermissionGranted(context, "android.permission.ACCESS_COARSE_LOCATION") || ApplicationUtil.isPermissionGranted(context, "android.permission.ACCESS_FINE_LOCATION")) {
                    Location newLocation;
                    PropertyValue currentLocationProperty = DeviceModel.this.properties[DeviceProperties.DeviceKeys.LAST_LOCATION];
                    Location currentLocation = null;
                    if (currentLocationProperty != null) {
                        currentLocation = (Location)currentLocationProperty.getValue();
                    }
                    if ((newLocation = LocationUtil.getUpdatedCurrentLocation()) != null) {
                        if (!LocationUtil.isSameLocation(newLocation, currentLocation)) {
                            model.setProperty(DeviceProperties.DeviceKeys.LAST_LOCATION, newLocation);
                            final Geocoder geocoder = new Geocoder(HelpshiftContext.getApplicationContext());
                            DeviceModel.this.workerQueue.dispatchAsync(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    boolean isCountryCodeFromLocation = false;
                                    try {
                                        Address address;
                                        String countryCode;
                                        List addresses = geocoder.getFromLocation(newLocation.getLatitude(), newLocation.getLongitude(), 1);
                                        if (addresses != null && addresses.size() > 0 && !TextUtils.isEmpty((CharSequence)(countryCode = (address = (Address)addresses.get(0)).getCountryCode()))) {
                                            model.setProperty(DeviceProperties.DeviceKeys.COUNTRY, countryCode);
                                            isCountryCodeFromLocation = true;
                                        }
                                    }
                                    catch (IOException e) {
                                        HSLogger.d(DeviceModel.TAG, "rescanDevice : ", e);
                                    }
                                    finally {
                                        if (!isCountryCodeFromLocation) {
                                            model.setProperty(DeviceProperties.DeviceKeys.COUNTRY, model.device.getCountryCode());
                                        }
                                    }
                                }
                            });
                        } else {
                            model.setProperty(DeviceProperties.DeviceKeys.COUNTRY, model.device.getCountryCode());
                        }
                    } else {
                        model.setProperty(DeviceProperties.DeviceKeys.COUNTRY, model.device.getCountryCode());
                    }
                } else {
                    model.setProperty(DeviceProperties.DeviceKeys.COUNTRY, model.device.getCountryCode());
                }
            }
        });
    }

    public void setPushToken(String pushToken) {
        this.setProperty(DeviceProperties.DeviceKeys.PUSH_TOKEN, pushToken);
    }

    public void setDevelopmentPlatform(String developmentPlatform) {
        this.setProperty(DeviceProperties.DeviceKeys.DEV_PLATFORM, developmentPlatform);
    }

    public HashMap<String, ArrayList> getUnsyncedProperties() {
        final HashMap<String, ArrayList> properties = new HashMap<String, ArrayList>();
        final DeviceModel model = this;
        this.workerQueue.dispatchSync(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 13; ++i) {
                    PropertyValue property = model.properties[i];
                    if (property == null || !property.getIsSynced().equals(SyncStatus.UNSYNCED)) continue;
                    properties.put(model.deviceKeys[i], property.getValueInfo());
                }
            }
        });
        return properties;
    }

    @NonNull
    public HashMap<String, ArrayList> getSyncedAndUnSyncedProperties() {
        final HashMap<String, ArrayList> properties = new HashMap<String, ArrayList>();
        final DeviceModel model = this;
        this.workerQueue.dispatchSync(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 13; ++i) {
                    PropertyValue property = model.properties[i];
                    if (property == null || SyncStatus.SYNCED != property.getIsSynced() && SyncStatus.UNSYNCED != property.getIsSynced()) continue;
                    properties.put(model.deviceKeys[i], property.getValueInfo());
                }
            }
        });
        return properties;
    }

    public HashMap<String, ArrayList> getSyncingPropertiesUnsafe() {
        HashMap<String, ArrayList> properties = new HashMap<String, ArrayList>();
        for (int i = 0; i < 13; ++i) {
            PropertyValue property = this.properties[i];
            if (property == null || !property.getIsSynced().equals(SyncStatus.SYNCING)) continue;
            properties.put(this.deviceKeys[i], property.getValueInfo());
        }
        return properties;
    }

    public void checkAndMarkPropertiesAsSynced(final List<String> keys) {
        if (keys != null) {
            final DeviceModel model = this;
            this.workerQueue.dispatchAsync(new Runnable(){

                @Override
                public void run() {
                    ArrayList<String> syncingKeys = new ArrayList<String>();
                    List<String> deviceKeysList = Arrays.asList(model.deviceKeys);
                    int deviceKeysListSize = deviceKeysList.size();
                    for (String key : keys) {
                        PropertyValue property;
                        int keyIndex = deviceKeysList.indexOf(key);
                        if (keyIndex < 0 || keyIndex >= deviceKeysListSize || (property = model.properties[keyIndex]) == null) continue;
                        if (property.getIsSynced().equals(SyncStatus.SYNCING)) {
                            property.setIsSynced(SyncStatus.SYNCED);
                            syncingKeys.add(key);
                            continue;
                        }
                        if (!DeviceModel.this.shouldDevicePropertySyncImmediately(keyIndex)) continue;
                        InfoModelFactory.getInstance().sdkInfoModel.setDevicePropertiesSyncImmediately(true);
                    }
                    DeviceModel.this.storage.setSecondaryPropertySyncStatus(SyncStatus.SYNCED, syncingKeys.toArray(new String[syncingKeys.size()]), DeviceModel.this.identifier);
                }
            });
        }
    }

    public void setSyncStatus(final Integer syncStatus, final ArrayList<String> keys) {
        if (keys != null) {
            final DeviceModel model = this;
            this.workerQueue.dispatchAsync(new Runnable(){

                @Override
                public void run() {
                    List<String> deviceKeysList = Arrays.asList(model.deviceKeys);
                    int deviceKeysListSize = deviceKeysList.size();
                    for (String key : keys) {
                        PropertyValue property;
                        int keyIndex = deviceKeysList.indexOf(key);
                        if (keyIndex < 0 || keyIndex >= deviceKeysListSize || (property = model.properties[keyIndex]) == null) continue;
                        property.setIsSynced(syncStatus);
                    }
                    DeviceModel.this.storage.setSecondaryPropertySyncStatus(syncStatus, keys.toArray(new String[keys.size()]), DeviceModel.this.identifier);
                }
            });
        }
    }

    boolean shouldDevicePropertySyncImmediately(Integer key) {
        return key.equals(DeviceProperties.DeviceKeys.APP_VERSION) || key.equals(DeviceProperties.DeviceKeys.OS) || key.equals(DeviceProperties.DeviceKeys.PUSH_TOKEN);
    }
}

