/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.support.annotation.NonNull;
import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.util.constants.SyncStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserModel {
    public final String identifier;
    public String name;
    public String email;
    PropertyStorage storage;
    HashMap<String, PropertyValue> properties;

    public UserModel(String identifier, PropertyStorage storage) {
        PropertyValue email;
        this.identifier = identifier;
        this.properties = storage.getAllProperties(identifier);
        this.storage = storage;
        PropertyValue name = storage.getProperty("name", identifier);
        if (name != null) {
            this.name = name.toString();
        }
        if ((email = storage.getProperty("email", identifier)) != null) {
            this.email = email.toString();
        }
    }

    public boolean addProperty(String key, PropertyValue value) {
        PropertyValue existingValue;
        boolean valueChanged = false;
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((existingValue = this.properties.get(key)) != null && existingValue.setValue(value) || existingValue == null) {
            valueChanged = true;
        }
        if (valueChanged) {
            this.properties.put(key, value);
            this.storage.setProperty(key, value, this.identifier);
        }
        return valueChanged;
    }

    public ArrayList<String> addProperties(HashMap<String, PropertyValue> properties) {
        ArrayList<String> propertiesChanged = new ArrayList<String>();
        for (Map.Entry<String, PropertyValue> entry : properties.entrySet()) {
            if (!this.addProperty(entry.getKey(), entry.getValue())) continue;
            propertiesChanged.add(entry.getKey());
        }
        return propertiesChanged;
    }

    public HashMap<String, PropertyValue> getUnsyncedProperties() {
        HashMap<String, PropertyValue> unsynced = new HashMap<String, PropertyValue>();
        if (this.properties != null) {
            for (Map.Entry<String, PropertyValue> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                PropertyValue value = entry.getValue();
                if (!value.getIsSynced().equals(SyncStatus.UNSYNCED)) continue;
                unsynced.put(key, value);
            }
        }
        return unsynced;
    }

    @NonNull
    public HashMap<String, PropertyValue> getSyncedAndUnSyncedProperties() {
        HashMap<String, PropertyValue> fullProperties = new HashMap<String, PropertyValue>();
        if (this.properties != null) {
            for (Map.Entry<String, PropertyValue> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                PropertyValue value = entry.getValue();
                if (value == null || SyncStatus.UNSYNCED != value.getIsSynced() && SyncStatus.SYNCED != value.getIsSynced()) continue;
                fullProperties.put(key, value);
            }
        }
        return fullProperties;
    }

    public HashMap<String, PropertyValue> getSyncingProperties() {
        HashMap<String, PropertyValue> syncing = new HashMap<String, PropertyValue>();
        if (this.properties != null) {
            for (Map.Entry<String, PropertyValue> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                PropertyValue value = entry.getValue();
                if (!value.getIsSynced().equals(SyncStatus.SYNCING)) continue;
                syncing.put(key, value);
            }
        }
        return syncing;
    }

    public HashMap<String, PropertyValue> getAllProperties() {
        return this.properties;
    }

    public void checkAndMarkPropertiesAsSynced(List<String> keys) {
        if (this.properties != null && keys != null) {
            ArrayList<String> syncingKeys = new ArrayList<String>();
            for (String key : keys) {
                PropertyValue value = this.properties.get(key);
                if (value == null || !value.getIsSynced().equals(SyncStatus.SYNCING)) continue;
                value.setIsSynced(SyncStatus.SYNCED);
                syncingKeys.add(key);
            }
            this.storage.setSyncStatus(SyncStatus.SYNCED, syncingKeys.toArray(new String[syncingKeys.size()]), this.identifier);
        }
    }

    public void setSyncStatus(Integer syncStatus, ArrayList<String> keys) {
        if (this.properties != null && keys != null) {
            for (String key : keys) {
                PropertyValue value = this.properties.get(key);
                if (value == null) continue;
                value.setIsSynced(syncStatus);
            }
            this.storage.setSyncStatus(syncStatus, keys.toArray(new String[keys.size()]), this.identifier);
        }
    }

    public void setNameAndEmail(String name, String email) {
        this.name = name;
        this.email = email;
    }
}

