/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import com.helpshift.campaigns.controllers.AnalyticsEventController;
import com.helpshift.campaigns.controllers.UserController;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.listeners.SyncListener;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.request.Request;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.ConnectivityUtil;
import com.helpshift.util.HSLogger;

public class AnalyticsEventNetworkManager
extends SyncListener {
    private static final String TAG = "Helpshift_AENewtork";
    private NetworkDataProvider dataProvider;
    private UserController userController;
    private RequestQueue requestQueue;
    private ConnectivityUtil connectivityUtil;
    private DataSyncCoordinator dataSyncCoordinator;

    public AnalyticsEventNetworkManager(AnalyticsEventController analyticsEventController, DataSyncCoordinator dataSyncCoordinator, UserController userController, RequestQueue requestQueue, ConnectivityUtil connectivityUtil) {
        super("data_type_analytics_event");
        this.dataProvider = analyticsEventController;
        analyticsEventController.syncController.addSyncListeners(this);
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.userController = userController;
        this.requestQueue = requestQueue;
        this.connectivityUtil = connectivityUtil;
    }

    @Override
    public boolean isFullSyncEnabled() {
        return false;
    }

    @Override
    public void sync() {
        if (this.dataSyncCoordinator.canSyncUserProperties(this.userController.getCurrentUser().identifier)) {
            this.dataProvider.setBatchSize(this.connectivityUtil.getBatchSize());
            Request newRequest = this.dataProvider.getRequest();
            if (newRequest != null) {
                HSLogger.d(TAG, "Syncing analytics events properties");
                this.requestQueue.add(newRequest);
            }
        }
    }
}

