/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import com.helpshift.campaigns.controllers.DeviceController;
import com.helpshift.listeners.SyncListener;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.request.Request;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.HSLogger;
import java.util.HashSet;
import java.util.Set;

public class DevicePropertiesNetworkManager
extends SyncListener {
    private static final String TAG = "Helpshift_DPNetwork";
    private NetworkDataProvider dataProvider;
    private RequestQueue requestQueue;
    private Set<String> dependentChildDataTypes;

    protected DevicePropertiesNetworkManager(DeviceController deviceController, RequestQueue requestQueue) {
        super("data_type_device");
        deviceController.syncController.addSyncListeners(this);
        this.dataProvider = deviceController;
        this.requestQueue = requestQueue;
        this.initDependentChildDataTypesSet();
    }

    private void initDependentChildDataTypesSet() {
        this.dependentChildDataTypes = new HashSet<String>();
        this.dependentChildDataTypes.add("data_type_switch_user");
        this.dependentChildDataTypes.add("data_type_analytics_event");
        this.dependentChildDataTypes.add("data_type_user");
    }

    @Override
    public Set<String> getDependentChildDataTypes() {
        return this.dependentChildDataTypes;
    }

    @Override
    public boolean isFullSyncEnabled() {
        return true;
    }

    @Override
    public void sync() {
        Request newRequest = this.dataProvider.getRequest();
        if (newRequest != null) {
            HSLogger.d(TAG, "Syncing device properties");
            this.requestQueue.add(newRequest);
        }
    }

    @Override
    public void fullSync() {
        Request newRequest = this.dataProvider.getRequestWithFullData();
        if (newRequest != null) {
            HSLogger.d(TAG, "Full sync device properties");
            this.requestQueue.add(newRequest);
        }
    }
}

