/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.network.AnalyticsEventNetworkManager;
import com.helpshift.campaigns.network.DevicePropertiesNetworkManager;
import com.helpshift.campaigns.network.InboxNetworkManager;
import com.helpshift.campaigns.network.SessionNetworkManager;
import com.helpshift.campaigns.network.SwitchUserNetworkManager;
import com.helpshift.campaigns.network.UserPropertiesNetworkManager;
import com.helpshift.common.domain.HSThreadFactory;
import com.helpshift.network.BasicNetwork;
import com.helpshift.network.HurlStack;
import com.helpshift.network.request.RequestManager;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.ConnectivityUtil;
import com.helpshift.util.HelpshiftContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NetworkManagerFactory {
    private SessionNetworkManager sessionNetworkManager;
    public DevicePropertiesNetworkManager devicePropertiesNetworkManager;
    public InboxNetworkManager inboxNetworkManager;
    private UserPropertiesNetworkManager userPropertiesNetworkManager;
    private SwitchUserNetworkManager switchUserNetworkManager;
    private AnalyticsEventNetworkManager analyticsEventNetworkManager;

    NetworkManagerFactory() {
        ExecutorService executorService = Executors.newCachedThreadPool(new HSThreadFactory("cmdat-sy"));
        RequestQueue requestQueue = RequestManager.newRequestQueue(new BasicNetwork(new HurlStack()), RequestQueue.DeliveryType.ON_NEW_THREAD, executorService);
        ControllerFactory controllerFactory = ControllerFactory.getInstance();
        ConnectivityUtil connectivityUtil = new ConnectivityUtil(4, 8, HelpshiftContext.getApplicationContext());
        this.sessionNetworkManager = new SessionNetworkManager(controllerFactory.sessionController, controllerFactory.userController, com.helpshift.controllers.ControllerFactory.getInstance().dataSyncCoordinator, requestQueue, connectivityUtil);
        this.devicePropertiesNetworkManager = new DevicePropertiesNetworkManager(controllerFactory.deviceController, requestQueue);
        this.userPropertiesNetworkManager = new UserPropertiesNetworkManager(controllerFactory.userController, com.helpshift.controllers.ControllerFactory.getInstance().dataSyncCoordinator, requestQueue, connectivityUtil);
        this.switchUserNetworkManager = new SwitchUserNetworkManager(controllerFactory.switchUserController, com.helpshift.controllers.ControllerFactory.getInstance().dataSyncCoordinator, requestQueue, connectivityUtil);
        this.analyticsEventNetworkManager = new AnalyticsEventNetworkManager(controllerFactory.analyticsEventController, com.helpshift.controllers.ControllerFactory.getInstance().dataSyncCoordinator, controllerFactory.userController, requestQueue, connectivityUtil);
        this.inboxNetworkManager = new InboxNetworkManager(controllerFactory.inboxSyncController, requestQueue);
    }

    public static NetworkManagerFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static class LazyHolder {
        static final NetworkManagerFactory INSTANCE = new NetworkManagerFactory();

        private LazyHolder() {
        }
    }
}

