/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import android.support.annotation.NonNull;
import com.helpshift.campaigns.controllers.SwitchUserController;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.listeners.SyncListener;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.request.Request;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.ConnectivityUtil;
import com.helpshift.util.HSLogger;
import java.util.HashSet;
import java.util.Set;

public class SwitchUserNetworkManager
extends SyncListener {
    private static final String TAG = "Helpshift_SUNetwork";
    private NetworkDataProvider dataProvider;
    private DataSyncCoordinator dataSyncCoordinator;
    private RequestQueue requestQueue;
    private ConnectivityUtil connectivityUtil;
    private Set<String> dependentChildDataTypes;

    protected SwitchUserNetworkManager(SwitchUserController switchUserController, DataSyncCoordinator dataSyncCoordinator, RequestQueue requestQueue, ConnectivityUtil connectivityUtil) {
        super("data_type_switch_user");
        switchUserController.syncController.addSyncListeners(this);
        this.dataProvider = switchUserController;
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.requestQueue = requestQueue;
        this.connectivityUtil = connectivityUtil;
        this.initDependentChildDataTypesSet();
    }

    private void initDependentChildDataTypesSet() {
        this.dependentChildDataTypes = new HashSet<String>();
        this.dependentChildDataTypes.add("data_type_analytics_event");
        this.dependentChildDataTypes.add("data_type_user");
    }

    @Override
    @NonNull
    public Set<String> getDependentChildDataTypes() {
        return this.dependentChildDataTypes;
    }

    @Override
    public boolean isFullSyncEnabled() {
        return false;
    }

    @Override
    public void sync() {
        if (this.dataSyncCoordinator.isFirstDeviceSyncComplete()) {
            this.dataProvider.setBatchSize(this.connectivityUtil.getBatchSize());
            Request newRequest = this.dataProvider.getRequest();
            if (newRequest != null) {
                HSLogger.d(TAG, "Syncing switch user");
                this.requestQueue.add(newRequest);
            }
        }
    }
}

