/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import com.helpshift.campaigns.controllers.UserController;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.listeners.SyncListener;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.request.Request;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.ConnectivityUtil;
import com.helpshift.util.HSLogger;

public class UserPropertiesNetworkManager
extends SyncListener {
    private static final String TAG = "Helpshift_UPNetwork";
    private NetworkDataProvider dataProvider;
    private RequestQueue requestQueue;
    private ConnectivityUtil connectivityUtil;
    private DataSyncCoordinator dataSyncCoordinator;

    protected UserPropertiesNetworkManager(UserController userController, DataSyncCoordinator dataSyncCoordinator, RequestQueue requestQueue, ConnectivityUtil connectivityUtil) {
        super("data_type_user");
        userController.syncController.addSyncListeners(this);
        this.dataProvider = userController;
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.requestQueue = requestQueue;
        this.connectivityUtil = connectivityUtil;
    }

    @Override
    public boolean isFullSyncEnabled() {
        return true;
    }

    private boolean shouldSync() {
        return this.dataSyncCoordinator.canSyncUserProperties(((UserController)this.dataProvider).getCurrentUser().identifier);
    }

    @Override
    public void sync() {
        if (this.shouldSync()) {
            this.dataProvider.setBatchSize(this.connectivityUtil.getBatchSize());
            Request newRequest = this.dataProvider.getRequest();
            if (newRequest != null) {
                HSLogger.d(TAG, "Syncing user properties");
                this.requestQueue.add(newRequest);
            }
        }
    }

    @Override
    public void fullSync() {
        if (this.shouldSync()) {
            this.dataProvider.setBatchSize(this.connectivityUtil.getBatchSize());
            Request newRequest = this.dataProvider.getRequestWithFullData();
            if (newRequest != null) {
                HSLogger.d(TAG, "Full sync user properties");
                this.requestQueue.add(newRequest);
            }
        }
    }
}

