/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.poller;

import android.support.annotation.Nullable;
import com.helpshift.common.domain.HSThreadFactory;
import com.helpshift.common.poller.Delay;
import com.helpshift.common.poller.HttpBackoff;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.poller.Poller;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CampaignsPoller
extends Poller {
    private final HttpBackoff successBackoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(3L, TimeUnit.MINUTES)).setMaxInterval(Delay.of(3L, TimeUnit.MINUTES)).setRandomness(0.0f).setMultiplier(1.0f).build();
    private final HttpBackoff failureBackoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(5L, TimeUnit.SECONDS)).setMaxInterval(Delay.of(10L, TimeUnit.MINUTES)).setRetryPolicy(HttpBackoff.RetryPolicy.FAILURE).build();

    public CampaignsPoller(Callable task) {
        super(task, Executors.newSingleThreadExecutor(new HSThreadFactory("cmpoll-a")), Executors.newSingleThreadScheduledExecutor(new HSThreadFactory("cmpoll-b")));
    }

    @Nullable
    public Delay getSuccessDelay(Object successData) {
        this.failureBackoff.reset();
        long delay = this.successBackoff.nextIntervalMillis(200);
        if (delay != -100L) {
            return Delay.of(delay, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    @Override
    @Nullable
    public Delay getFailDelay(Exception e) {
        Integer errorCode;
        this.successBackoff.reset();
        long delay = -100L;
        if (e instanceof NetworkError && (errorCode = ((NetworkError)e).getReason()) != null) {
            delay = this.failureBackoff.nextIntervalMillis(errorCode);
        }
        if (delay != -100L) {
            return Delay.of(delay, TimeUnit.MILLISECONDS);
        }
        return null;
    }
}

