/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.presenters;

import android.app.Activity;
import android.graphics.Bitmap;
import android.text.TextUtils;
import com.helpshift.R;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.interactors.CampaignDetailInteractor;
import com.helpshift.campaigns.models.ActionModel;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.observers.CampaignDetailObserver;
import com.helpshift.campaigns.observers.CampaignDetailPresenterObserver;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.ImageUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CampaignDetailPresenter
implements CampaignDetailObserver {
    private CampaignDetailInteractor detailInteractor;
    private List<CampaignDetailPresenterObserver> observers;

    public CampaignDetailPresenter(CampaignDetailInteractor campaignDetailInteractor) {
        this.detailInteractor = campaignDetailInteractor;
        this.observers = new ArrayList<CampaignDetailPresenterObserver>();
    }

    public HashMap<String, Object> getCoverImage() {
        HashMap<String, Object> imageInfo = new HashMap<String, Object>();
        Bitmap imageBitmap = null;
        CampaignDetailModel campaignDetailModel = this.detailInteractor.getCampaignDetailModel();
        String coverImageUrl = "";
        if (campaignDetailModel != null) {
            imageBitmap = ImageUtil.getBitmap(campaignDetailModel.coverImageFilePath, -1);
            coverImageUrl = campaignDetailModel.coverImageUrl;
        }
        if (imageBitmap == null && campaignDetailModel != null && !TextUtils.isEmpty((CharSequence)coverImageUrl)) {
            File file;
            imageBitmap = ImageUtil.getBitmap(HelpshiftContext.getApplicationContext().getResources(), R.drawable.hs__cam_inbox_default_cover, -1);
            imageInfo.put("default", true);
            String coverImageFilePath = campaignDetailModel.coverImageFilePath;
            if (!TextUtils.isEmpty((CharSequence)coverImageFilePath) && (file = new File(coverImageFilePath)).exists()) {
                file.delete();
            }
            ControllerFactory.getInstance().inboxSyncController.startCoverImageDownload(coverImageUrl, campaignDetailModel.getIdentifier());
        } else {
            ControllerFactory.getInstance().inboxSyncController.resetCorruptImageDownloadRetryCount(coverImageUrl);
        }
        imageInfo.put("bitmap", imageBitmap);
        return imageInfo;
    }

    public String getTitle() {
        String title = "";
        if (this.detailInteractor.getCampaignDetailModel() != null) {
            title = this.detailInteractor.getCampaignDetailModel().getTitle();
        }
        return title;
    }

    public String getTitleColor() {
        String titleColor = "";
        if (this.detailInteractor.getCampaignDetailModel() != null) {
            titleColor = this.detailInteractor.getCampaignDetailModel().getTitleColor();
        }
        return titleColor;
    }

    public String getBody() {
        String body = "";
        if (this.detailInteractor.getCampaignDetailModel() != null) {
            body = this.detailInteractor.getCampaignDetailModel().getBody();
        }
        return body;
    }

    public String getTextColor() {
        String textColor = "";
        if (this.detailInteractor.getCampaignDetailModel() != null) {
            textColor = this.detailInteractor.getCampaignDetailModel().getBodyColor();
        }
        return textColor;
    }

    public String getBackgroundColor() {
        String backgroundColor = "";
        if (this.detailInteractor.getCampaignDetailModel() != null) {
            backgroundColor = this.detailInteractor.getCampaignDetailModel().getBackgroundColor();
        }
        return backgroundColor;
    }

    public boolean isExpired() {
        CampaignDetailModel campaign = this.detailInteractor.getCampaignDetailModel();
        return campaign != null && campaign.isExpired();
    }

    public int getCountOfActions() {
        List<ActionModel> actions = null;
        if (this.detailInteractor.getCampaignDetailModel() != null) {
            actions = this.detailInteractor.getCampaignDetailModel().actions;
        }
        if (actions != null) {
            return actions.size();
        }
        return 0;
    }

    public String getActionTitle(int index) {
        String title = "";
        if (this.detailInteractor.getCampaignDetailModel() != null && index >= 0 && index < this.detailInteractor.getCampaignDetailModel().actions.size()) {
            ActionModel action = this.detailInteractor.getCampaignDetailModel().actions.get(index);
            title = action.title;
        }
        return title;
    }

    public String getActionTitleColor(int index) {
        String titleColor = "";
        if (this.detailInteractor.getCampaignDetailModel() != null && index >= 0 && index < this.detailInteractor.getCampaignDetailModel().actions.size()) {
            ActionModel action = this.detailInteractor.getCampaignDetailModel().actions.get(index);
            titleColor = action.textColor;
        }
        return titleColor;
    }

    public void markCampaignAsSeen() {
        if (!this.isExpired()) {
            this.detailInteractor.markCampaignAsSeen();
        }
    }

    public void buttonClicked(int index, Activity activity) {
        this.detailInteractor.executeAction(index, activity);
    }

    @Override
    public void campaignDetailAdded() {
        for (CampaignDetailPresenterObserver observer : this.observers) {
            observer.dataChanged();
        }
    }

    @Override
    public void campaignIconImageDownloaded() {
    }

    @Override
    public void campaignCoverImageDownloaded() {
        for (CampaignDetailPresenterObserver observer : this.observers) {
            observer.dataChanged();
        }
    }

    public void addObserver(CampaignDetailPresenterObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(CampaignDetailPresenterObserver observer) {
        this.observers.remove(observer);
    }

    public void setUp() {
        this.detailInteractor.setUp();
        this.detailInteractor.addObserver(this);
    }

    public void cleanUp() {
        this.detailInteractor.cleanUp();
        this.detailInteractor.removeObserver(this);
    }
}

