/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.presenters;

import android.graphics.Bitmap;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.MenuItem;
import com.helpshift.R;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.interactors.CampaignsListInteractor;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.observers.CampaignListObserver;
import com.helpshift.campaigns.observers.CampaignListPresenterObserver;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.ImageUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CampaignListPresenter
implements CampaignListObserver,
SearchView.OnQueryTextListener,
MenuItemCompat.OnActionExpandListener,
MenuItem.OnActionExpandListener {
    private final CampaignsListInteractor campaignListInteractor;
    private List<CampaignListPresenterObserver> observers;
    private static String currentQuery;
    private static boolean retainSearchState;
    private static boolean campaignClickedFromSearchResult;

    public CampaignListPresenter(CampaignsListInteractor campaignsListInteractor) {
        this.campaignListInteractor = campaignsListInteractor;
        this.observers = new ArrayList<CampaignListPresenterObserver>();
    }

    public int getCountOfCampaigns() {
        return this.campaignListInteractor.getCountOfCampaigns();
    }

    public String getTitle(int index) {
        String title = "";
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        if (campaignDetailModel != null) {
            title = campaignDetailModel.getTitle();
        }
        return title;
    }

    public String getCampaignId(int index) {
        String campaignId = "";
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        if (campaignDetailModel != null) {
            campaignId = campaignDetailModel.getIdentifier();
        }
        return campaignId;
    }

    public HashMap<String, Object> getIconImage(int index) {
        HashMap<String, Object> iconImageObject = new HashMap<String, Object>();
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        Bitmap iconImageBitmap = null;
        String iconImageUrl = "";
        if (campaignDetailModel != null) {
            iconImageBitmap = ImageUtil.getBitmap(campaignDetailModel.iconImageFilePath, -1);
            iconImageUrl = campaignDetailModel.iconImageUrl;
        }
        if (iconImageBitmap == null) {
            iconImageObject.put("default", true);
            iconImageBitmap = ImageUtil.getBitmap(HelpshiftContext.getApplicationContext().getResources(), R.drawable.hs__cam_inbox_default_icon, -1);
            if (campaignDetailModel != null && !TextUtils.isEmpty((CharSequence)iconImageUrl)) {
                File file;
                String iconImageFilePath = campaignDetailModel.iconImageFilePath;
                if (!TextUtils.isEmpty((CharSequence)iconImageFilePath) && (file = new File(iconImageFilePath)).exists()) {
                    file.delete();
                }
                ControllerFactory.getInstance().inboxSyncController.startIconImageDownload(iconImageUrl, campaignDetailModel.getIdentifier());
            }
        } else {
            ControllerFactory.getInstance().inboxSyncController.resetCorruptImageDownloadRetryCount(iconImageUrl);
        }
        iconImageObject.put("bitmap", iconImageBitmap);
        return iconImageObject;
    }

    public String getBody(int index) {
        String body = "";
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        if (campaignDetailModel != null) {
            body = campaignDetailModel.getBody();
        }
        return body;
    }

    public boolean getReadStatus(int index) {
        boolean readStatus = false;
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        if (campaignDetailModel != null) {
            readStatus = campaignDetailModel.getReadStatus();
        }
        return readStatus;
    }

    public boolean getSeenStatus(int index) {
        boolean seenStatus = false;
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        if (campaignDetailModel != null) {
            seenStatus = campaignDetailModel.getSeenStatus();
        }
        return seenStatus;
    }

    public long getTimestamp(int index) {
        long createdAt = 0L;
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        if (campaignDetailModel != null) {
            createdAt = campaignDetailModel.getCreatedAt();
        }
        return createdAt;
    }

    public void deleteRow(int index, boolean withUndo) {
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        if (campaignDetailModel != null) {
            this.campaignListInteractor.deleteCampaign(campaignDetailModel.getIdentifier(), withUndo);
        }
    }

    public void undoTimedOut() {
        this.campaignListInteractor.undoTimedOut();
    }

    public void undoDeletedCampaign() {
        this.campaignListInteractor.undoDeletedCampaign();
    }

    public void markCampaignAsRead(int index) {
        CampaignDetailModel campaignDetailModel = this.campaignListInteractor.getCampaign(index);
        if (campaignDetailModel != null) {
            this.campaignListInteractor.markCampaignAsRead(campaignDetailModel.getIdentifier());
        }
    }

    public void addObserver(CampaignListPresenterObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(CampaignListPresenterObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void campaignAdded() {
        for (CampaignListPresenterObserver observer : this.observers) {
            observer.dataChanged();
        }
    }

    @Override
    public void campaignIconImageDownloaded() {
        for (CampaignListPresenterObserver observer : this.observers) {
            observer.dataChanged();
        }
    }

    @Override
    public void campaignMarkedAsSeen() {
        for (CampaignListPresenterObserver observer : this.observers) {
            observer.dataChanged();
        }
    }

    @Override
    public void searchResultsUpdated() {
        for (CampaignListPresenterObserver observer : this.observers) {
            observer.dataChanged();
        }
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        for (CampaignListPresenterObserver observer : this.observers) {
            observer.performedSearch();
        }
        if (campaignClickedFromSearchResult) {
            campaignClickedFromSearchResult = false;
        } else {
            currentQuery = newText;
            this.performSearch(newText);
        }
        return true;
    }

    public void performSearch(String query) {
        this.campaignListInteractor.performSearch(query);
    }

    public void setRetainSearchState(boolean newRetainSearchState) {
        retainSearchState = newRetainSearchState;
    }

    public boolean getRetainSearchState() {
        return retainSearchState;
    }

    public void setCampaignClickedFromSearchResult(boolean newCampaignClickedFromSearchResult) {
        campaignClickedFromSearchResult = newCampaignClickedFromSearchResult;
    }

    public boolean onMenuItemActionExpand(MenuItem item) {
        for (CampaignListPresenterObserver observer : this.observers) {
            observer.searchActionStarted();
        }
        this.campaignListInteractor.searchActionStarted();
        return true;
    }

    public boolean onMenuItemActionCollapse(MenuItem item) {
        for (CampaignListPresenterObserver observer : this.observers) {
            observer.searchActionStopped();
        }
        this.campaignListInteractor.searchActionStopped();
        return true;
    }

    public String getCurrentQuery() {
        return currentQuery;
    }

    public void setUp() {
        this.campaignListInteractor.setUp();
        this.campaignListInteractor.setObserver(this);
    }

    public void cleanUp() {
        this.campaignListInteractor.cleanUp();
        this.campaignListInteractor.setObserver(null);
    }

    public void cleanUpExpiredCampaigns() {
        this.campaignListInteractor.cleanUpExpiredCampaigns();
    }
}

