/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.observers.CampaignStorageObserver;
import com.helpshift.campaigns.storage.CampaignDbStorageHelper;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.util.ByteArrayUtil;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CampaignDbStorage
implements CampaignStorage {
    private static final String TAG = "Helpshift_CampDBStore";
    private final CampaignDbStorageHelper helper = new CampaignDbStorageHelper(HelpshiftContext.getApplicationContext());
    private ConcurrentLinkedQueue<CampaignStorageObserver> observers = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCampaign(CampaignDetailModel newCampaign) {
        if (newCampaign == null || TextUtils.isEmpty((CharSequence)newCampaign.getIdentifier()) || TextUtils.isEmpty((CharSequence)newCampaign.userIdentifier) || TextUtils.isEmpty((CharSequence)newCampaign.getTitle()) || TextUtils.isEmpty((CharSequence)newCampaign.getBody()) || TextUtils.isEmpty((CharSequence)newCampaign.iconImageUrl)) {
            return;
        }
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            boolean isTransactionSuccessful = false;
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{newCampaign.getIdentifier()};
                if (!DatabaseUtils.exists(db, "campaigns", whereClause, whereArgs)) {
                    db.insert("campaigns", null, this.campaignToContentValues(newCampaign));
                }
                isTransactionSuccessful = true;
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception in adding campaign with id " + newCampaign.getIdentifier(), e);
            }
            if (isTransactionSuccessful) {
                for (CampaignStorageObserver observer : this.observers) {
                    observer.campaignDetailModelAdded(newCampaign);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCampaignWithIconImageFilePath(String campaignId, String imageFilePath) {
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            return;
        }
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            boolean isTransactionSuccessful = false;
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{campaignId};
                if (DatabaseUtils.exists(db, "campaigns", whereClause, whereArgs)) {
                    ContentValues updateValues = new ContentValues();
                    updateValues.put("icon_image_file_path", imageFilePath);
                    db.update("campaigns", updateValues, whereClause, whereArgs);
                }
                isTransactionSuccessful = true;
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception in updating icon image path for " + campaignId, e);
            }
            if (isTransactionSuccessful) {
                for (CampaignStorageObserver observer : this.observers) {
                    observer.campaignIconImageFilePathUpdated(campaignId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCampaignWIthCoverImageFilePath(String campaignId, String imageFilePath) {
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            return;
        }
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            boolean isTransactionSuccessful = false;
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{campaignId};
                if (DatabaseUtils.exists(db, "campaigns", whereClause, whereArgs)) {
                    ContentValues updateValues = new ContentValues();
                    updateValues.put("cover_image_file_path", imageFilePath);
                    db.update("campaigns", updateValues, whereClause, whereArgs);
                }
                isTransactionSuccessful = true;
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception in updating cover image path for " + campaignId, e);
            }
            if (isTransactionSuccessful) {
                for (CampaignStorageObserver observer : this.observers) {
                    observer.campaignCoverImageFilePathUpdated(campaignId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markCampaignAsRead(String campaignId) {
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            return;
        }
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            boolean isTransactionSuccessful = false;
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{campaignId};
                if (DatabaseUtils.exists(db, "campaigns", whereClause, whereArgs)) {
                    ContentValues updateValues = new ContentValues();
                    updateValues.put("read_status", Integer.valueOf(1));
                    db.update("campaigns", updateValues, whereClause, whereArgs);
                }
                isTransactionSuccessful = true;
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception in marking campaign as read for id : " + campaignId, e);
            }
            if (isTransactionSuccessful) {
                for (CampaignStorageObserver observer : this.observers) {
                    observer.campaignRead(campaignId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markCampaignAsSeen(String campaignId) {
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            return;
        }
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            boolean isTransactionSuccessful = false;
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{campaignId};
                if (DatabaseUtils.exists(db, "campaigns", whereClause, whereArgs)) {
                    ContentValues updateValues = new ContentValues();
                    updateValues.put("seen_status", Integer.valueOf(1));
                    updateValues.put("read_status", Integer.valueOf(1));
                    db.update("campaigns", updateValues, whereClause, whereArgs);
                }
                isTransactionSuccessful = true;
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception in marking campaign as read for id : " + campaignId, e);
            }
            if (isTransactionSuccessful) {
                for (CampaignStorageObserver observer : this.observers) {
                    observer.campaignSeen(campaignId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CampaignDetailModel> getAllCampaigns(String userIdentifier) {
        if (TextUtils.isEmpty((CharSequence)userIdentifier)) {
            return null;
        }
        ArrayList<CampaignDetailModel> allCampaigns = null;
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase db = this.helper.getReadableDatabase();
                String whereClause = "user_identifier=?";
                String[] whereArgs = new String[]{userIdentifier};
                String orderBy = "created_at DESC";
                cursor = db.query("campaigns", null, whereClause, whereArgs, null, null, orderBy);
                if (cursor.moveToFirst()) {
                    allCampaigns = new ArrayList<CampaignDetailModel>();
                    while (!cursor.isAfterLast()) {
                        allCampaigns.add(this.cursorToCampaignDetailModel(cursor));
                        cursor.moveToNext();
                    }
                }
            }
        }
        return allCampaigns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CampaignDetailModel> getAllCampaigns(boolean readStatus, String userIdentifier) {
        if (TextUtils.isEmpty((CharSequence)userIdentifier)) {
            return null;
        }
        ArrayList<CampaignDetailModel> campaigns = null;
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase db = this.helper.getReadableDatabase();
                String readStatusString = readStatus ? "1" : "0";
                String whereClause = "read_status=" + readStatusString + " and " + "user_identifier" + "=?";
                String[] whereArgs = new String[]{userIdentifier};
                String orderBy = "created_at DESC";
                cursor = db.query("campaigns", null, whereClause, whereArgs, null, null, orderBy);
                if (cursor.moveToFirst()) {
                    campaigns = new ArrayList<CampaignDetailModel>();
                    while (!cursor.isAfterLast()) {
                        campaigns.add(this.cursorToCampaignDetailModel(cursor));
                        cursor.moveToNext();
                    }
                }
            }
        }
        return campaigns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CampaignDetailModel getCampaign(String campaignId) {
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            return null;
        }
        CampaignDetailModel campaign = null;
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase db = this.helper.getReadableDatabase();
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{campaignId};
                cursor = db.query("campaigns", null, whereClause, whereArgs, null, null, null);
                if (cursor.moveToFirst()) {
                    campaign = this.cursorToCampaignDetailModel(cursor);
                }
            }
        }
        return campaign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCampaign(String campaignId) {
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            return;
        }
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            boolean isTransactionSuccessful = false;
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{campaignId};
                db.delete("campaigns", whereClause, whereArgs);
                isTransactionSuccessful = true;
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception in deleting campaign for id " + campaignId, e);
            }
            if (isTransactionSuccessful) {
                for (CampaignStorageObserver observer : this.observers) {
                    observer.campaignDeleted(campaignId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCampaigns(String[] campaignIds) {
        if (campaignIds == null || campaignIds.length == 0) {
            return;
        }
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            boolean isTransactionSuccessful = false;
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                String whereClause = "identifier in (" + DatabaseUtils.makePlaceholders(campaignIds.length) + ")";
                db.delete("campaigns", whereClause, campaignIds);
                isTransactionSuccessful = true;
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception in deleting campaigns ", e);
            }
            if (isTransactionSuccessful) {
                for (CampaignStorageObserver observer : this.observers) {
                    for (String campaignId : campaignIds) {
                        observer.campaignDeleted(campaignId);
                    }
                }
            }
        }
    }

    @Override
    public void addObserver(CampaignStorageObserver campaignStorageObserver) {
        if (campaignStorageObserver != null) {
            this.observers.add(campaignStorageObserver);
        }
    }

    @Override
    public void removeObserver(CampaignStorageObserver campaignStorageObserver) {
        this.observers.remove(campaignStorageObserver);
    }

    private ContentValues campaignToContentValues(CampaignDetailModel campaignDetailModel) {
        ContentValues values = new ContentValues();
        values.put("identifier", campaignDetailModel.getIdentifier());
        values.put("user_identifier", campaignDetailModel.userIdentifier);
        values.put("title", campaignDetailModel.getTitle());
        values.put("body", campaignDetailModel.getBody());
        values.put("cover_image_url", campaignDetailModel.coverImageUrl);
        values.put("cover_image_file_path", campaignDetailModel.coverImageFilePath);
        values.put("icon_image_url", campaignDetailModel.iconImageUrl);
        values.put("icon_image_file_path", campaignDetailModel.iconImageFilePath);
        values.put("background_color", campaignDetailModel.getBackgroundColor());
        values.put("title_color", campaignDetailModel.getTitleColor());
        values.put("text_color", campaignDetailModel.getBodyColor());
        try {
            values.put("actions", ByteArrayUtil.toByteArray(campaignDetailModel.actions));
        }
        catch (IOException e) {
            values.put("actions", "");
        }
        try {
            values.put("messages", ByteArrayUtil.toByteArray(campaignDetailModel.messages));
        }
        catch (IOException e) {
            values.put("messages", "");
        }
        values.put("read_status", Integer.valueOf(campaignDetailModel.getReadStatus() ? 1 : 0));
        values.put("seen_status", Integer.valueOf(campaignDetailModel.getSeenStatus() ? 1 : 0));
        values.put("created_at", Long.valueOf(campaignDetailModel.getCreatedAt()));
        values.put("expiry_time_stamp", Long.valueOf(campaignDetailModel.getExpiryTimeStamp()));
        values.put("extra_data", "");
        return values;
    }

    private CampaignDetailModel cursorToCampaignDetailModel(Cursor cursor) {
        ArrayList actions = null;
        try {
            actions = (ArrayList)ByteArrayUtil.toObject(cursor.getBlob(cursor.getColumnIndex("actions")));
        }
        catch (IOException e) {
            HSLogger.e(TAG, "IO exception in retrieving campaign actions :", e);
        }
        catch (ClassNotFoundException e) {
            HSLogger.e(TAG, "Class not found exception in retrieving campaign actions :", e);
        }
        catch (ClassCastException e) {
            HSLogger.e(TAG, "Class cast Exception in retrieving campaign actions :", e);
        }
        ArrayList messages = null;
        try {
            messages = (ArrayList)ByteArrayUtil.toObject(cursor.getBlob(cursor.getColumnIndex("messages")));
        }
        catch (IOException e) {
            HSLogger.e(TAG, "IO exception in retrieving campaign messages :", e);
        }
        catch (ClassNotFoundException e) {
            HSLogger.e(TAG, "Class not found exception in retrieving campaign messages :", e);
        }
        catch (ClassCastException e) {
            HSLogger.e(TAG, "Class cast Exception in retrieving campaign messages :", e);
        }
        return new CampaignDetailModel(cursor.getString(cursor.getColumnIndex("identifier")), cursor.getString(cursor.getColumnIndex("user_identifier")), cursor.getString(cursor.getColumnIndex("title")), cursor.getString(cursor.getColumnIndex("body")), cursor.getString(cursor.getColumnIndex("cover_image_url")), cursor.getString(cursor.getColumnIndex("cover_image_file_path")), cursor.getString(cursor.getColumnIndex("icon_image_url")), cursor.getString(cursor.getColumnIndex("icon_image_file_path")), cursor.getString(cursor.getColumnIndex("background_color")), cursor.getString(cursor.getColumnIndex("title_color")), cursor.getString(cursor.getColumnIndex("text_color")), cursor.getInt(cursor.getColumnIndex("read_status")) == 1, cursor.getInt(cursor.getColumnIndex("seen_status")) == 1, cursor.getLong(cursor.getColumnIndex("created_at")), cursor.getLong(cursor.getColumnIndex("expiry_time_stamp")), actions, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitStorage() {
        CampaignDbStorageHelper campaignDbStorageHelper = this.helper;
        synchronized (campaignDbStorageHelper) {
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                db.delete("campaigns", null, null);
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Exception while reinitializing the storage");
            }
        }
    }
}

