/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.storage;

import android.text.TextUtils;
import com.helpshift.campaigns.models.CampaignSyncModel;
import com.helpshift.campaigns.observers.CampaignSyncModelStorageObserver;
import com.helpshift.campaigns.storage.CampaignSyncModelStorage;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.concurrent.DispatchQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CampaignSyncModelDbStorage
implements CampaignSyncModelStorage {
    KeyValueStorage storage;
    private DispatchQueue workerQueue;
    private static final String SYNC_MODEL_KEY_PREFIX = "kCampaignSyncModels";
    ConcurrentLinkedQueue<CampaignSyncModelStorageObserver> observers;

    public CampaignSyncModelDbStorage(KeyValueStorage keyValueStorage, DispatchQueue dispatchQueue) {
        this.storage = keyValueStorage;
        this.workerQueue = dispatchQueue;
        this.observers = new ConcurrentLinkedQueue();
    }

    @Override
    public void destroyStorage(String userIdentifier) {
        this.storage.removeKey(SYNC_MODEL_KEY_PREFIX + userIdentifier);
    }

    @Override
    public void addCampaign(final CampaignSyncModel campaignSyncModel, final String userIdentifier) {
        if (campaignSyncModel == null || TextUtils.isEmpty((CharSequence)campaignSyncModel.campaignId) || TextUtils.isEmpty((CharSequence)campaignSyncModel.creativeUrl) || TextUtils.isEmpty((CharSequence)userIdentifier)) {
            return;
        }
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                HashMap<String, CampaignSyncModel> campaignSyncModels = (HashMap<String, CampaignSyncModel>)CampaignSyncModelDbStorage.this.storage.get(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier);
                if (campaignSyncModels == null) {
                    campaignSyncModels = new HashMap<String, CampaignSyncModel>();
                }
                campaignSyncModels.put(campaignSyncModel.campaignId, campaignSyncModel);
                CampaignSyncModelDbStorage.this.storage.set(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier, campaignSyncModels);
                for (CampaignSyncModelStorageObserver observer : CampaignSyncModelDbStorage.this.observers) {
                    observer.campaignAdded(campaignSyncModel);
                }
            }
        });
    }

    @Override
    public void markCampaignAsSynced(final String campaignId, final String userIdentifier) {
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                HashMap campaignSyncModels = (HashMap)CampaignSyncModelDbStorage.this.storage.get(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier);
                if (campaignSyncModels != null) {
                    campaignSyncModels.remove(campaignId);
                    CampaignSyncModelDbStorage.this.storage.set(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier, campaignSyncModels);
                    for (CampaignSyncModelStorageObserver observer : CampaignSyncModelDbStorage.this.observers) {
                        observer.campaignSynced(campaignId);
                    }
                }
            }
        });
    }

    @Override
    public void markCampaignAsSyncing(final String campaignId, final String userIdentifier) {
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                HashMap campaignSyncModels = (HashMap)CampaignSyncModelDbStorage.this.storage.get(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier);
                if (campaignSyncModels != null) {
                    CampaignSyncModel syncModel = (CampaignSyncModel)campaignSyncModels.get(campaignId);
                    if (syncModel != null) {
                        syncModel.setIsSyncing(true);
                    }
                    campaignSyncModels.put(campaignId, syncModel);
                    CampaignSyncModelDbStorage.this.storage.set(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier, campaignSyncModels);
                }
            }
        });
    }

    @Override
    public void markCampaignAsUnSynced(final String campaignId, final String userIdentifier) {
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                HashMap campaignSyncModels = (HashMap)CampaignSyncModelDbStorage.this.storage.get(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier);
                if (campaignSyncModels != null) {
                    CampaignSyncModel syncModel = (CampaignSyncModel)campaignSyncModels.get(campaignId);
                    if (syncModel != null) {
                        syncModel.setIsSyncing(false);
                    }
                    campaignSyncModels.put(campaignId, syncModel);
                    CampaignSyncModelDbStorage.this.storage.set(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier, campaignSyncModels);
                }
            }
        });
    }

    @Override
    public List<CampaignSyncModel> getAllUnsyncedCampaigns(String userIdentifier) {
        HashMap campaignSyncModels = (HashMap)this.storage.get(SYNC_MODEL_KEY_PREFIX + userIdentifier);
        ArrayList<CampaignSyncModel> unsyncedCampaigns = new ArrayList<CampaignSyncModel>();
        if (campaignSyncModels != null) {
            for (String key : campaignSyncModels.keySet()) {
                CampaignSyncModel campaign = (CampaignSyncModel)campaignSyncModels.get(key);
                if (campaign == null || campaign.isSyncing()) continue;
                unsyncedCampaigns.add(campaign);
            }
        }
        return unsyncedCampaigns;
    }

    @Override
    public CampaignSyncModel getCampaign(String campaignId, String userIdentifier) {
        CampaignSyncModel campaignSyncModel = null;
        HashMap campaignSyncModels = (HashMap)this.storage.get(SYNC_MODEL_KEY_PREFIX + userIdentifier);
        if (campaignSyncModels != null) {
            campaignSyncModel = (CampaignSyncModel)campaignSyncModels.get(campaignId);
        }
        return campaignSyncModel;
    }

    @Override
    public void addObserver(CampaignSyncModelStorageObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    @Override
    public void removeObserver(CampaignSyncModelStorageObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void cleanUpSyncingModels(final String userIdentifier) {
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                HashMap campaignSyncModels = (HashMap)CampaignSyncModelDbStorage.this.storage.get(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier);
                HashMap<String, CampaignSyncModel> newCampaignSyncModels = new HashMap<String, CampaignSyncModel>();
                if (campaignSyncModels != null) {
                    for (String key : campaignSyncModels.keySet()) {
                        CampaignSyncModel campaign = (CampaignSyncModel)campaignSyncModels.get(key);
                        if (campaign.isSyncing()) {
                            campaign.setIsSyncing(false);
                        }
                        newCampaignSyncModels.put(key, campaign);
                    }
                }
                CampaignSyncModelDbStorage.this.storage.set(CampaignSyncModelDbStorage.SYNC_MODEL_KEY_PREFIX + userIdentifier, newCampaignSyncModels);
            }
        });
    }
}

