/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.helpshift.util.StringUtil;
import java.util.HashSet;

public class PropertyDbHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "__hs__db_properties";
    private static final Integer DATABASE_VERSION = 1;
    private HashSet<String> identifiers = new HashSet();

    PropertyDbHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION.intValue());
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
    }

    public synchronized void createIdentifierTable(SQLiteDatabase sqLiteDatabase, String identifier) {
        this.identifiers.add(identifier);
        sqLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS " + this.getTableName(identifier) + " (" + "key" + " text primary key, " + "value" + " blob, " + "type" + " text, " + "sync_status" + " int, " + "extras" + " blob);");
    }

    public void dropIdentifierTable(SQLiteDatabase sqLiteDatabase, String identifier) {
        sqLiteDatabase.execSQL("DROP TABLE IF EXISTS " + this.getTableName(identifier) + ";");
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
        this.dropTables(sqLiteDatabase);
        this.onCreate(sqLiteDatabase);
    }

    public void onDowngrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
        this.dropTables(sqLiteDatabase);
        this.onCreate(sqLiteDatabase);
    }

    public void dropTables(SQLiteDatabase sqLiteDatabase) {
        for (String identifier : this.identifiers) {
            this.dropIdentifierTable(sqLiteDatabase, identifier);
        }
    }

    String getTableName(String identifier) {
        return StringUtil.escapeForSql("property_" + identifier);
    }
}

