/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.storage.PropertyDbHelper;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.util.HashMap;

public class PropertyDbStorage
implements PropertyStorage {
    private static final String TAG = "Helpshift_PropertyDB";
    private final PropertyDbHelper helper = new PropertyDbHelper(HelpshiftContext.getApplicationContext());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initStorage(String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            try {
                SQLiteDatabase database = this.helper.getWritableDatabase();
                this.helper.createIdentifierTable(database, sanitizedIdentifier);
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error initStorage", e);
            }
        }
    }

    @Override
    public void initSecondaryStorage(String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        this.initStorage(this.getSecondaryName(sanitizedIdentifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitStorage(String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            SQLiteDatabase database = null;
            try {
                database = this.helper.getWritableDatabase();
                database.beginTransaction();
                this.helper.dropIdentifierTable(database, sanitizedIdentifier);
                this.helper.createIdentifierTable(database, sanitizedIdentifier);
                database.setTransactionSuccessful();
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error reinitStorage", e);
            }
            finally {
                try {
                    if (database != null && database.inTransaction()) {
                        database.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error reinitStorage inside finally block", e);
                }
            }
        }
    }

    @Override
    public void reinitSecondaryStorage(String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        this.reinitStorage(this.getSecondaryName(sanitizedIdentifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, PropertyValue value, String identifier) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null || TextUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            try {
                SQLiteDatabase database = this.helper.getWritableDatabase();
                String tableName = this.helper.getTableName(sanitizedIdentifier);
                String whereClause = "key=?";
                String[] whereArgs = new String[]{key};
                if (DatabaseUtils.exists(database, tableName, whereClause, whereArgs)) {
                    database.update(tableName, this.propertyToContentValues(key, value), whereClause, whereArgs);
                } else {
                    database.insert(tableName, null, this.propertyToContentValues(key, value));
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error setProperty key: " + key + ", value : " + value, e);
            }
        }
    }

    @Override
    public void setSecondaryProperty(String key, PropertyValue value, String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        this.setProperty(key, value, this.getSecondaryName(sanitizedIdentifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyValue getProperty(String key, String identifier) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        PropertyValue value = null;
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase database = this.helper.getReadableDatabase();
                String whereClause = "key=?";
                String[] whereArgs = new String[]{key};
                cursor = database.query(this.helper.getTableName(sanitizedIdentifier), null, whereClause, whereArgs, null, null, null);
                if (cursor.moveToFirst()) {
                    value = this.cursorToPropertyValue(cursor);
                }
            }
        }
        return value;
    }

    @Override
    public PropertyValue getSecondaryProperty(String key, String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        return this.getProperty(key, this.getSecondaryName(sanitizedIdentifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncStatus(Integer syncStatus, String key, String identifier) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            try {
                SQLiteDatabase database = this.helper.getWritableDatabase();
                String whereClause = "key=?";
                String[] whereArgs = new String[]{key};
                ContentValues updateValues = new ContentValues();
                updateValues.put("sync_status", syncStatus);
                database.update(this.helper.getTableName(sanitizedIdentifier), updateValues, whereClause, whereArgs);
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error setSyncStatus key: " + key, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncStatus(Integer syncStatus, String[] keys, String identifier) {
        if (keys == null || keys.length == 0 || TextUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            SQLiteDatabase database = null;
            try {
                database = this.helper.getWritableDatabase();
                database.beginTransaction();
                String whereClause = "key in (" + DatabaseUtils.makePlaceholders(keys.length) + ")";
                ContentValues updateValues = new ContentValues();
                updateValues.put("sync_status", syncStatus);
                database.update(this.helper.getTableName(sanitizedIdentifier), updateValues, whereClause, keys);
                database.setTransactionSuccessful();
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error setSyncStatus for multiple keys", e);
            }
            finally {
                try {
                    if (database != null && database.inTransaction()) {
                        database.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error setSyncStatus for multiple keys inside finally block", e);
                }
            }
        }
    }

    @Override
    public void setSecondaryPropertySyncStatus(Integer syncStatus, String[] keys, String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        this.setSyncStatus(syncStatus, keys, this.getSecondaryName(sanitizedIdentifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, PropertyValue> getUnsyncedProperties(String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        HashMap<String, PropertyValue> unSyncedProperties = null;
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase database = this.helper.getReadableDatabase();
                String whereClause = "sync_status=?";
                String[] whereArgs = new String[]{"" + SyncStatus.UNSYNCED};
                cursor = database.query(this.helper.getTableName(sanitizedIdentifier), null, whereClause, whereArgs, null, null, null);
                if (cursor.moveToFirst()) {
                    unSyncedProperties = new HashMap<String, PropertyValue>();
                    while (!cursor.isAfterLast()) {
                        PropertyValue value = this.cursorToPropertyValue(cursor);
                        String key = cursor.getString(0);
                        unSyncedProperties.put(key, value);
                        cursor.moveToNext();
                    }
                }
            }
        }
        return unSyncedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, PropertyValue> getAllProperties(String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        HashMap<String, PropertyValue> allProperties = null;
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase database = this.helper.getReadableDatabase();
                cursor = database.query(this.helper.getTableName(sanitizedIdentifier), null, null, null, null, null, null);
                if (cursor.moveToFirst()) {
                    allProperties = new HashMap<String, PropertyValue>();
                    while (!cursor.isAfterLast()) {
                        PropertyValue value = this.cursorToPropertyValue(cursor);
                        String key = cursor.getString(0);
                        allProperties.put(key, value);
                        cursor.moveToNext();
                    }
                }
            }
        }
        return allProperties;
    }

    @Override
    public HashMap<String, PropertyValue> getAllSecondaryProperties(String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        return this.getAllProperties(this.getSecondaryName(sanitizedIdentifier));
    }

    private ContentValues propertyToContentValues(String key, PropertyValue value) {
        ContentValues values = new ContentValues();
        values.put("key", key);
        values.put("value", value.toString());
        values.put("type", value.getType());
        values.put("sync_status", value.getIsSynced());
        values.put("extras", "");
        return values;
    }

    private PropertyValue cursorToPropertyValue(Cursor cursor) {
        PropertyValue newValue = new PropertyValue(cursor.getString(2), cursor.getString(1));
        newValue.setIsSynced(cursor.getInt(3));
        return newValue;
    }

    private String getSecondaryName(String identifier) {
        String sanitizedIdentifier = this.sanitizeForSQL(identifier);
        return sanitizedIdentifier + "__hs_secondary_data";
    }

    private String sanitizeForSQL(String identifier) {
        return identifier.replaceAll("'", "$");
    }
}

