/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.helpshift.campaigns.models.SessionModel;
import com.helpshift.campaigns.models.SessionModelBuilder;
import com.helpshift.campaigns.storage.SessionDbStorageHelper;
import com.helpshift.campaigns.storage.SessionStorage;
import com.helpshift.util.ByteArrayUtil;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SessionDbStorage
implements SessionStorage {
    private static final String TAG = "Helpshift_SessionDB";
    private final SessionDbStorageHelper helper = new SessionDbStorageHelper(HelpshiftContext.getApplicationContext());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSession(SessionModel newSession) {
        if (newSession == null) {
            return;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            try {
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{newSession.identifier};
                SQLiteDatabase db = this.helper.getWritableDatabase();
                if (DatabaseUtils.exists(db, "sessions", whereClause, whereArgs)) {
                    db.update("sessions", this.sessionToContentValues(newSession), whereClause, whereArgs);
                } else {
                    db.insert("sessions", null, this.sessionToContentValues(newSession));
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error storing sessions", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSession(SessionModel session) {
        if (session == null) {
            return;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            block8: {
                try {
                    String whereClause = "identifier=?";
                    String[] whereArgs = new String[]{session.identifier};
                    SQLiteDatabase db = this.helper.getWritableDatabase();
                    if (!DatabaseUtils.exists(db, "sessions", whereClause, whereArgs)) break block8;
                    ContentValues updateValues = new ContentValues();
                    updateValues.put("start_time", Long.valueOf(session.startTime));
                    updateValues.put("end_time", Long.valueOf(session.endTime > 0L ? session.endTime : 0L));
                    try {
                        updateValues.put("durations", ByteArrayUtil.toByteArray(session.durations));
                    }
                    catch (IOException e) {
                        updateValues.put("durations", "");
                    }
                    db.update("sessions", updateValues, whereClause, whereArgs);
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error updating session", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncStatus(Integer syncStatus, String[] sessionIds) {
        if (sessionIds == null) {
            return;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            SQLiteDatabase db = null;
            try {
                ContentValues updateValues = new ContentValues();
                updateValues.put("sync_status", syncStatus);
                int batchSize = 900;
                List<List<String>> batches = DatabaseUtils.createBatches(batchSize, Arrays.asList(sessionIds));
                db = this.helper.getWritableDatabase();
                db.beginTransaction();
                for (List<String> batch : batches) {
                    String[] batchedSessions = batch.toArray(new String[batch.size()]);
                    String whereClause = "identifier in (" + DatabaseUtils.makePlaceholders(batchedSessions.length) + ")";
                    db.update("sessions", updateValues, whereClause, batchedSessions);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in setting sync status", e);
            }
            finally {
                try {
                    if (db != null && db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in setting sync status inside finally block, ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessions(String[] sessionIds) {
        if (sessionIds == null) {
            return;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            SQLiteDatabase db = null;
            try {
                int batchSize = 900;
                List<List<String>> batches = DatabaseUtils.createBatches(batchSize, Arrays.asList(sessionIds));
                db = this.helper.getWritableDatabase();
                db.beginTransaction();
                for (List<String> batch : batches) {
                    String[] batchedSessions = batch.toArray(new String[batch.size()]);
                    String whereClause = "identifier in (" + DatabaseUtils.makePlaceholders(batchedSessions.length) + ")";
                    db.delete("sessions", whereClause, batchedSessions);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error removing sessions", e);
            }
            finally {
                try {
                    if (db != null && db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error removing sessions inside finally block, ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<SessionModel> getAllSessions(Integer syncStatus) {
        ArrayList<SessionModel> sessions = new ArrayList<SessionModel>();
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            try (Cursor cursor = null;){
                SQLiteDatabase db = this.helper.getReadableDatabase();
                String whereClause = "sync_status=? AND end_time>?";
                String[] whereArgs = new String[]{String.valueOf(syncStatus), String.valueOf(0)};
                cursor = db.query("sessions", null, whereClause, whereArgs, null, null, null);
                if (cursor.moveToFirst()) {
                    while (!cursor.isAfterLast()) {
                        sessions.add(this.cursorToSessionModel(cursor));
                        cursor.moveToNext();
                    }
                }
            }
        }
        return sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cleanUpInvalidSessions() {
        int num = 0;
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            try {
                String whereClause = "end_time=0";
                SQLiteDatabase db = this.helper.getWritableDatabase();
                num = db.delete("sessions", whereClause, null);
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error cleaning up invalid sessions", e);
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionModel getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        SessionModel session = null;
        Cursor cursor = null;
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            try {
                String whereClause = "identifier=?";
                String[] whereArgs = new String[]{sessionId};
                SQLiteDatabase db = this.helper.getReadableDatabase();
                cursor = db.query("sessions", null, whereClause, whereArgs, null, null, null);
                if (cursor.moveToFirst()) {
                    session = this.cursorToSessionModel(cursor);
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error getting session", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitStorage() {
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            try {
                SQLiteDatabase db = this.helper.getWritableDatabase();
                db.delete("sessions", null, null);
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error reiniting session storage", e);
            }
        }
    }

    private ContentValues sessionToContentValues(SessionModel sessionModel) {
        ContentValues values = new ContentValues();
        values.put("identifier", sessionModel.identifier);
        values.put("device_identifier", sessionModel.deviceIdentifier);
        values.put("user_identifier", sessionModel.userIdentifier);
        values.put("start_time", Long.valueOf(sessionModel.startTime));
        values.put("end_time", Long.valueOf(sessionModel.endTime > 0L ? sessionModel.endTime : 0L));
        try {
            values.put("durations", ByteArrayUtil.toByteArray(sessionModel.durations));
        }
        catch (IOException e) {
            values.put("durations", "");
        }
        values.put("sync_status", sessionModel.syncStatus);
        values.put("extras", "");
        return values;
    }

    private SessionModel cursorToSessionModel(Cursor cursor) {
        SessionModelBuilder builder = new SessionModelBuilder(cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getLong(3)).setEndTime(cursor.getLong(4)).setSyncStatus(cursor.getInt(6));
        try {
            builder = builder.setDurations((ArrayList)ByteArrayUtil.toObject(cursor.getBlob(5)));
        }
        catch (IOException e) {
            builder = builder.setDurations(null);
            HSLogger.e(TAG, "IO Exception in retrieving session duration :", e);
        }
        catch (ClassNotFoundException e) {
            builder = builder.setDurations(null);
            HSLogger.e(TAG, "Class not found Exception in retrieving session duration :", e);
        }
        catch (ClassCastException e) {
            builder = builder.setDurations(null);
            HSLogger.e(TAG, "Class cast Exception in retrieving session duration :", e);
        }
        return builder.build();
    }
}

