/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.storage;

import com.helpshift.campaigns.storage.CampaignDbStorage;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.campaigns.storage.CampaignSyncModelDbStorage;
import com.helpshift.campaigns.storage.CampaignSyncModelStorage;
import com.helpshift.campaigns.storage.PropertyDbStorage;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.storage.SessionDbStorage;
import com.helpshift.campaigns.storage.SessionStorage;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.concurrent.DispatchQueue;

public class StorageFactory {
    public final PropertyStorage propertyStorage;
    public final SessionStorage sessionStorage;
    public final CampaignStorage campaignStorage;
    public final CampaignSyncModelStorage campaignSyncModelStorage;

    StorageFactory() {
        KeyValueStorage keyValueStorage = com.helpshift.storage.StorageFactory.getInstance().keyValueStorage;
        this.propertyStorage = new PropertyDbStorage();
        this.sessionStorage = new SessionDbStorage();
        this.campaignStorage = new CampaignDbStorage();
        this.campaignSyncModelStorage = new CampaignSyncModelDbStorage(keyValueStorage, new DispatchQueue(false));
    }

    public static StorageFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        static final StorageFactory INSTANCE = new StorageFactory();

        private LazyHolder() {
        }
    }
}

