/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.util;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import com.helpshift.R;
import com.helpshift.campaigns.activities.NotificationActivity;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.campaigns.models.CampaignSyncModel;
import com.helpshift.campaigns.services.NotificationService;
import com.helpshift.campaigns.storage.StorageFactory;
import com.helpshift.campaigns.util.InAppCampaignsUtil;
import com.helpshift.enums.ACTION_TYPE;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.TextUtils;
import com.helpshift.util.Xml;
import java.util.HashMap;

public class CampaignsNotification {
    public static String getCampaignsId(Intent intent) {
        String changeSetId = intent.getStringExtra("cid");
        String action = intent.getStringExtra("hsp.a");
        if (changeSetId != null && ACTION_TYPE.SHOW_INBOX == ACTION_TYPE.getEnum(action)) {
            return InAppCampaignsUtil.getCampaignIdForLoggedInUser(changeSetId);
        }
        return changeSetId;
    }

    public static NotificationCompat.Builder createNotification(Context context, Intent intent) {
        PendingIntent pendingIntent;
        Boolean muteNotifications;
        String uid = ControllerFactory.getInstance().userController.getCurrentUser().identifier;
        String campaignId = intent.getStringExtra("cid");
        if (InfoModelFactory.getInstance().sdkInfoModel.isDuplicateNotification(campaignId, uid)) {
            return null;
        }
        String action = intent.getStringExtra("hsp.a");
        String data = intent.getStringExtra("hsp.d");
        String alert = intent.getStringExtra("alert");
        String appName = intent.getStringExtra("app_name");
        String category = intent.getStringExtra("category");
        HashMap<String, Object> actionsData = CampaignsNotification.getActionsData(context, category);
        if (ACTION_TYPE.SHOW_INBOX == ACTION_TYPE.getEnum(action)) {
            String changeSetId = campaignId;
            campaignId = InAppCampaignsUtil.getCampaignIdForLoggedInUser(changeSetId);
            InfoModelFactory.getInstance().sdkInfoModel.setChangeSetId(changeSetId, campaignId);
            long expiryTimeStamp = Long.MAX_VALUE;
            String expires = intent.getStringExtra("expires");
            if (!TextUtils.isEmpty(expires)) {
                expiryTimeStamp = Long.parseLong(expires);
            }
            CampaignSyncModel syncModel = new CampaignSyncModel(campaignId, data, System.currentTimeMillis() / 1000L, expiryTimeStamp, false);
            StorageFactory.getInstance().campaignSyncModelStorage.addCampaign(syncModel, uid);
        }
        if (!((muteNotifications = InfoModelFactory.getInstance().appInfoModel.muteNotifications) != null && muteNotifications.booleanValue() || (pendingIntent = CampaignsNotification.getPendingIntent(context, action, data, campaignId, AnalyticsEvent.AnalyticsEventType.VIEW, true)) == null)) {
            Bitmap largeNotificationIcon;
            NotificationCompat.Builder notification = new NotificationCompat.Builder(context);
            notification.setContentText((CharSequence)alert);
            notification.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)alert));
            notification.setWhen(System.currentTimeMillis());
            notification.setAutoCancel(true);
            notification.setContentIntent(pendingIntent);
            int[] actionIds = (int[])actionsData.get("actionIds");
            int[] actionIcons = (int[])actionsData.get("actionIcons");
            String[] actionLabels = (String[])actionsData.get("actionLabels");
            boolean[] foregroundStatus = (boolean[])actionsData.get("foregroundStatus");
            boolean[] requiresAuth = (boolean[])actionsData.get("requiresAuth");
            notification = CampaignsNotification.addAction(notification, context, intent, actionIds[1], actionIcons[1], actionLabels[1], campaignId, foregroundStatus[1]);
            notification = CampaignsNotification.addAction(notification, context, intent, actionIds[0], actionIcons[0], actionLabels[0], campaignId, foregroundStatus[0]);
            if (requiresAuth[0] || requiresAuth[1]) {
                notification.setVisibility(0);
            }
            if (appName != null) {
                notification.setContentTitle((CharSequence)appName);
            } else {
                notification.setContentTitle((CharSequence)ApplicationUtil.getApplicationName(context));
            }
            Integer notificationIcon = InfoModelFactory.getInstance().appInfoModel.notificationIconId;
            if (notificationIcon == null) {
                notificationIcon = Xml.getLogoResourceValue(context);
            }
            notification.setSmallIcon(notificationIcon.intValue());
            Integer largeNotificationIconId = InfoModelFactory.getInstance().appInfoModel.largeNotificationIconId;
            if (largeNotificationIconId != null && (largeNotificationIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeNotificationIconId)) != null) {
                notification.setLargeIcon(largeNotificationIcon);
            }
            Uri soundUri = null;
            Integer sound = InfoModelFactory.getInstance().appInfoModel.notificationSoundId;
            if (sound != null) {
                String soundUriString = "android.resource://" + context.getPackageName() + "/" + sound;
                soundUri = Uri.parse((String)soundUriString);
            }
            boolean hasVibratePermission = ApplicationUtil.isPermissionGranted(context, "android.permission.VIBRATE");
            if (soundUri == null) {
                if (hasVibratePermission) {
                    notification.setDefaults(-1);
                } else {
                    notification.setDefaults(5);
                }
            } else {
                notification.setSound(soundUri);
                if (hasVibratePermission) {
                    notification.setDefaults(6);
                } else {
                    notification.setDefaults(4);
                }
            }
            return notification;
        }
        return null;
    }

    private static PendingIntent getPendingIntent(Context context, String action, String data, String campaignId, int type, boolean foregroundStatus) {
        Intent notificationLauncher;
        if (foregroundStatus) {
            notificationLauncher = new Intent(context, NotificationActivity.class);
            notificationLauncher.setFlags(0x10008000);
        } else {
            notificationLauncher = new Intent(context, NotificationService.class);
        }
        notificationLauncher.putExtra("action", action);
        notificationLauncher.putExtra("data", data);
        notificationLauncher.putExtra("campaignId", campaignId);
        notificationLauncher.putExtra("type", type);
        notificationLauncher.putExtra("foregroundStatus", foregroundStatus);
        notificationLauncher.setAction(campaignId + type);
        if (foregroundStatus) {
            return PendingIntent.getActivity((Context)context, (int)1, (Intent)notificationLauncher, (int)0x10000000);
        }
        return PendingIntent.getService((Context)context, (int)1, (Intent)notificationLauncher, (int)0x10000000);
    }

    private static NotificationCompat.Builder addAction(NotificationCompat.Builder notification, Context context, Intent intent, int actionId, int actionIcon, String actionLabel, String campaignId, boolean foregroundStatus) {
        if (actionIcon != 0 && actionLabel != null) {
            String action = intent.getStringExtra(actionId + ".a");
            String data = intent.getStringExtra(actionId + ".d");
            PendingIntent actionPendingIntent = CampaignsNotification.getPendingIntent(context, action, data, campaignId, actionId, foregroundStatus);
            notification.addAction(actionIcon, (CharSequence)actionLabel, actionPendingIntent);
        }
        return notification;
    }

    private static HashMap<String, Object> getActionsData(Context context, String category) {
        HashMap<String, Object> actionData = new HashMap<String, Object>();
        int[] actionsIds = new int[2];
        int[] actionIcons = new int[2];
        String[] actionLabels = new String[2];
        boolean[] foregroundStatus = new boolean[2];
        boolean[] requiresAuth = new boolean[2];
        Resources resources = context.getResources();
        if (category != null) {
            switch (category) {
                case "hs1": {
                    actionsIds[0] = 100;
                    actionsIds[1] = 101;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_yes);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_no);
                    actionIcons[0] = R.drawable.hs__cam_action_yes;
                    actionIcons[1] = R.drawable.hs__cam_action_no;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs2": {
                    actionsIds[0] = 102;
                    actionsIds[1] = 103;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_yes);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_no);
                    actionIcons[0] = R.drawable.hs__cam_action_yes;
                    actionIcons[1] = R.drawable.hs__cam_action_no;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = true;
                    break;
                }
                case "hs3": {
                    actionsIds[0] = 104;
                    actionsIds[1] = 105;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_yes);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_no);
                    actionIcons[0] = R.drawable.hs__cam_action_yes;
                    actionIcons[1] = R.drawable.hs__cam_action_no;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs4": {
                    actionsIds[0] = 106;
                    actionsIds[1] = 107;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_accept);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_decline);
                    actionIcons[0] = R.drawable.hs__cam_action_yes;
                    actionIcons[1] = R.drawable.hs__cam_action_no;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs5": {
                    actionsIds[0] = 108;
                    actionsIds[1] = 109;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_accept);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_decline);
                    actionIcons[0] = R.drawable.hs__cam_action_yes;
                    actionIcons[1] = R.drawable.hs__cam_action_no;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs6": {
                    actionsIds[0] = 110;
                    actionsIds[1] = 111;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_accept);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_decline);
                    actionIcons[0] = R.drawable.hs__cam_action_yes;
                    actionIcons[1] = R.drawable.hs__cam_action_no;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs7": {
                    actionsIds[0] = 112;
                    actionsIds[1] = 113;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_shop_now);
                    actionIcons[0] = R.drawable.hs__cam_action_shop_now;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs8": {
                    actionsIds[0] = 114;
                    actionsIds[1] = 115;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_shop_now);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_later);
                    actionIcons[0] = R.drawable.hs__cam_action_shop_now;
                    actionIcons[1] = R.drawable.hs__cam_action_later;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs9": {
                    actionsIds[0] = 116;
                    actionsIds[1] = 117;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_launch);
                    actionIcons[0] = R.drawable.hs__cam_action_launch;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs10": {
                    actionsIds[0] = 118;
                    actionsIds[1] = 119;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_launch);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_later);
                    actionIcons[0] = R.drawable.hs__cam_action_launch;
                    actionIcons[1] = R.drawable.hs__cam_action_later;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs11": {
                    actionsIds[0] = 120;
                    actionsIds[1] = 121;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_buy_now);
                    actionIcons[0] = R.drawable.hs__cam_action_shop_now;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs12": {
                    actionsIds[0] = 122;
                    actionsIds[1] = 123;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_buy_now);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_later);
                    actionIcons[0] = R.drawable.hs__cam_action_shop_now;
                    actionIcons[1] = R.drawable.hs__cam_action_later;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs13": {
                    actionsIds[0] = 124;
                    actionsIds[1] = 125;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_book_now);
                    actionIcons[0] = R.drawable.hs__cam_action_book_now;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs14": {
                    actionsIds[0] = 126;
                    actionsIds[1] = 127;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_book_now);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_later);
                    actionIcons[0] = R.drawable.hs__cam_action_book_now;
                    actionIcons[1] = R.drawable.hs__cam_action_later;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs15": {
                    actionsIds[0] = 128;
                    actionsIds[1] = 129;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_download);
                    actionIcons[0] = R.drawable.hs__cam_action_download;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs16": {
                    actionsIds[0] = 130;
                    actionsIds[1] = 131;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_share);
                    actionIcons[0] = R.drawable.hs__cam_action_share;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs17": {
                    actionsIds[0] = 132;
                    actionsIds[1] = 133;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_like);
                    actionIcons[0] = R.drawable.hs__cam_action_like;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs18": {
                    actionsIds[0] = 134;
                    actionsIds[1] = 135;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_like);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_dislike);
                    actionIcons[0] = R.drawable.hs__cam_action_like;
                    actionIcons[1] = R.drawable.hs__cam_action_dislike;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs19": {
                    actionsIds[0] = 136;
                    actionsIds[1] = 137;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_like);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_share);
                    actionIcons[0] = R.drawable.hs__cam_action_like;
                    actionIcons[1] = R.drawable.hs__cam_action_share;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs20": {
                    actionsIds[0] = 138;
                    actionsIds[1] = 139;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_send_feedback);
                    actionIcons[0] = R.drawable.hs__cam_action_send_feedback;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs21": {
                    actionsIds[0] = 140;
                    actionsIds[1] = 141;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_chat_now);
                    actionIcons[0] = R.drawable.hs__cam_action_chat_now;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs22": {
                    actionsIds[0] = 142;
                    actionsIds[1] = 143;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_read_faqs);
                    actionIcons[0] = R.drawable.hs__cam_action_help;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs23": {
                    actionsIds[0] = 144;
                    actionsIds[1] = 145;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_read_faq);
                    actionIcons[0] = R.drawable.hs__cam_action_help;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs24": {
                    actionsIds[0] = 146;
                    actionsIds[1] = 147;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_reply);
                    actionIcons[0] = R.drawable.hs__cam_action_reply;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs25": {
                    actionsIds[0] = 148;
                    actionsIds[1] = 149;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_open_help);
                    actionIcons[0] = R.drawable.hs__cam_action_help;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs26": {
                    actionsIds[0] = 150;
                    actionsIds[1] = 151;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_rate);
                    actionIcons[0] = R.drawable.hs__cam_action_rate;
                    foregroundStatus[0] = true;
                    requiresAuth[0] = true;
                    break;
                }
                case "hs27": {
                    actionsIds[0] = 152;
                    actionsIds[1] = 153;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_rate);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_later);
                    actionIcons[0] = R.drawable.hs__cam_action_rate;
                    actionIcons[1] = R.drawable.hs__cam_action_later;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = false;
                    requiresAuth[0] = true;
                    requiresAuth[1] = false;
                    break;
                }
                case "hs28": {
                    actionsIds[0] = 154;
                    actionsIds[1] = 155;
                    actionLabels[0] = resources.getString(R.string.hs__cam_action_rate);
                    actionLabels[1] = resources.getString(R.string.hs__cam_action_send_feedback);
                    actionIcons[0] = R.drawable.hs__cam_action_rate;
                    actionIcons[1] = R.drawable.hs__cam_action_send_feedback;
                    foregroundStatus[0] = true;
                    foregroundStatus[1] = true;
                    requiresAuth[0] = true;
                    requiresAuth[1] = true;
                    break;
                }
            }
        }
        actionData.put("actionIds", actionsIds);
        actionData.put("actionLabels", actionLabels);
        actionData.put("actionIcons", actionIcons);
        actionData.put("foregroundStatus", foregroundStatus);
        actionData.put("requiresAuth", requiresAuth);
        return actionData;
    }
}

