/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.util;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import com.helpshift.R;
import com.helpshift.campaigns.fragments.InboxFragment;
import com.helpshift.model.InfoModelFactory;

public class FragmentUtil {
    public static void startFragment(FragmentManager fragmentManager, int fragmentContainerId, Fragment fragment, String tag, String backStackName, boolean executePendingTransactions) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        Fragment previous = fragmentManager.findFragmentById(fragmentContainerId);
        if (!InfoModelFactory.getInstance().appInfoModel.disableAnimations.booleanValue()) {
            if (previous == null) {
                fragmentTransaction.setCustomAnimations(0, 0, 0, 0);
            } else {
                fragmentTransaction.setCustomAnimations(R.anim.hs__slide_in_from_right, R.anim.hs__slide_out_to_left, R.anim.hs__slide_in_from_left, R.anim.hs__slide_out_to_right);
            }
        }
        fragmentTransaction.replace(fragmentContainerId, fragment, tag);
        if (!TextUtils.isEmpty((CharSequence)backStackName)) {
            fragmentTransaction.addToBackStack(backStackName);
        }
        fragmentTransaction.commit();
        if (executePendingTransactions) {
            fragmentManager.executePendingTransactions();
        }
    }

    public static void removeFragment(FragmentManager fragmentManager, Fragment fragment) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.remove(fragment);
        fragmentTransaction.commit();
    }

    public static InboxFragment getInboxFragment(Fragment fragment) {
        Fragment parentFragment = fragment.getParentFragment();
        if (parentFragment == null) {
            return null;
        }
        if (parentFragment instanceof InboxFragment) {
            return (InboxFragment)parentFragment;
        }
        return FragmentUtil.getInboxFragment(parentFragment);
    }
}

