/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.util;

import com.helpshift.campaigns.controllers.AnalyticsEventController;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.TextUtils;
import com.helpshift.util.concurrent.DispatchQueue;
import java.util.ArrayList;
import java.util.List;

public final class InAppCampaignsUtil {
    private static DispatchQueue workerQueue = new DispatchQueue(false);

    private InAppCampaignsUtil() {
    }

    public static String getCampaignIdForLoggedInUser(String changeSetId) {
        String uid = ControllerFactory.getInstance().userController.getCurrentUser().identifier;
        return changeSetId + ":" + uid;
    }

    public static List<CampaignDetailModel> cleanAndGetActiveCampaigns(CampaignStorage campaignStorage, String userIdentifier) {
        if (campaignStorage == null || TextUtils.isEmpty(userIdentifier)) {
            return null;
        }
        List<CampaignDetailModel> allCampaigns = campaignStorage.getAllCampaigns(userIdentifier);
        return InAppCampaignsUtil.removeExpiredCampaigns(campaignStorage, allCampaigns);
    }

    public static List<CampaignDetailModel> cleanAndGetActiveCampaigns(CampaignStorage campaignStorage, boolean readStatus, String userIdentifier) {
        if (campaignStorage == null || TextUtils.isEmpty(userIdentifier)) {
            return null;
        }
        List<CampaignDetailModel> allCampaigns = campaignStorage.getAllCampaigns(readStatus, userIdentifier);
        return InAppCampaignsUtil.removeExpiredCampaigns(campaignStorage, allCampaigns);
    }

    private static List<CampaignDetailModel> removeExpiredCampaigns(final CampaignStorage campaignStorage, List<CampaignDetailModel> campaigns) {
        ArrayList<CampaignDetailModel> activeCampaigns = new ArrayList<CampaignDetailModel>();
        final ArrayList<String> expiredCampaignIds = new ArrayList<String>();
        long currentTime = System.currentTimeMillis() / 1000L;
        if (campaigns != null) {
            for (CampaignDetailModel campaign : campaigns) {
                long expiryTime = campaign.getExpiryTimeStamp();
                if (expiryTime == Long.MAX_VALUE || expiryTime > currentTime) {
                    activeCampaigns.add(campaign);
                    continue;
                }
                expiredCampaignIds.add(campaign.getIdentifier());
            }
        }
        if (expiredCampaignIds.size() > 0) {
            workerQueue.dispatchAsync(new Runnable(){

                @Override
                public void run() {
                    campaignStorage.deleteCampaigns(expiredCampaignIds.toArray(new String[0]));
                    AnalyticsEventController analyticsEventController = ControllerFactory.getInstance().analyticsEventController;
                    for (String campaignId : expiredCampaignIds) {
                        ApplicationUtil.cancelNotification(campaignId);
                        analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.DELETE_EXPIRED_MESSAGE, campaignId, false);
                    }
                }
            });
        }
        return activeCampaigns;
    }
}

