/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;

@SuppressLint(value={"AppCompatCustomView"})
public class AdjustableImageView
extends ImageView {
    boolean mAdjustViewBounds;

    public AdjustableImageView(Context context) {
        super(context);
    }

    public AdjustableImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AdjustableImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        this.mAdjustViewBounds = adjustViewBounds;
        super.setAdjustViewBounds(adjustViewBounds);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable mDrawable = this.getDrawable();
        if (mDrawable == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (this.mAdjustViewBounds) {
            int mDrawableWidth = mDrawable.getIntrinsicWidth();
            int mDrawableHeight = mDrawable.getIntrinsicHeight();
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            if (heightMode == 0x40000000 && widthMode != 0x40000000) {
                int height = heightSize;
                int width = height * mDrawableWidth / mDrawableHeight;
                if (this.isInScrollingContainer()) {
                    this.setMeasuredDimension(width, height);
                } else {
                    this.setMeasuredDimension(Math.min(width, widthSize), Math.min(height, heightSize));
                }
            } else if (widthMode == 0x40000000 && heightMode != 0x40000000) {
                int width = widthSize;
                int height = width * mDrawableHeight / mDrawableWidth;
                if (this.isInScrollingContainer()) {
                    this.setMeasuredDimension(width, height);
                } else {
                    this.setMeasuredDimension(Math.min(width, widthSize), Math.min(height, heightSize));
                }
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (!((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }
}

