/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.widget.ImageView;

@SuppressLint(value={"AppCompatCustomView"})
public class CircleImageView
extends ImageView {
    private static final ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLOR_DRAWABLE_DIMENSION = 2;
    private final RectF drawableRect = new RectF();
    private final RectF borderRect = new RectF();
    private final Matrix shaderMatrix = new Matrix();
    private final Paint bitmapPaint = new Paint();
    private Bitmap bitmap;
    private BitmapShader bitmapShader;
    private int bitmapWidth;
    private int bitmapHeight;
    private float drawableRadius;
    private ColorFilter colorFilter;
    private boolean isReady;
    private boolean isSetupPending;

    public CircleImageView(Context context) {
        super(context);
        this.init();
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        super.setScaleType(SCALE_TYPE);
        this.isReady = true;
        if (this.isSetupPending) {
            this.setup();
            this.isSetupPending = false;
        }
    }

    public ImageView.ScaleType getScaleType() {
        return SCALE_TYPE;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != SCALE_TYPE) {
            throw new IllegalArgumentException(String.format("ScaleType %s not supported.", scaleType));
        }
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (adjustViewBounds) {
            throw new IllegalArgumentException("adjustViewBounds not supported.");
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.bitmap == null) {
            return;
        }
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, this.drawableRadius, this.bitmapPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setup();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.bitmap = bm;
        this.setup();
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.bitmap = this.getBitmapFromDrawable(drawable2);
        this.setup();
    }

    public void setImageResource(@DrawableRes int resId) {
        super.setImageResource(resId);
        this.bitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.bitmap = uri != null ? this.getBitmapFromDrawable(this.getDrawable()) : null;
        this.setup();
    }

    public void setColorFilter(ColorFilter cf) {
        if (cf == this.colorFilter) {
            return;
        }
        this.colorFilter = cf;
        this.bitmapPaint.setColorFilter(this.colorFilter);
        this.invalidate();
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        try {
            Bitmap bitmap = drawable2 instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setup() {
        if (!this.isReady) {
            this.isSetupPending = true;
            return;
        }
        if (this.getWidth() == 0 && this.getHeight() == 0) {
            return;
        }
        if (this.bitmap == null) {
            this.invalidate();
            return;
        }
        this.bitmapShader = new BitmapShader(this.bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.bitmapPaint.setAntiAlias(true);
        this.bitmapPaint.setShader((Shader)this.bitmapShader);
        this.bitmapHeight = this.bitmap.getHeight();
        this.bitmapWidth = this.bitmap.getWidth();
        this.borderRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.drawableRect.set(this.borderRect);
        this.drawableRadius = Math.min(this.drawableRect.height() / 2.0f, this.drawableRect.width() / 2.0f);
        this.updateShaderMatrix();
        this.invalidate();
    }

    private void updateShaderMatrix() {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        this.shaderMatrix.set(null);
        if ((float)this.bitmapWidth * this.drawableRect.height() > this.drawableRect.width() * (float)this.bitmapHeight) {
            scale = this.drawableRect.height() / (float)this.bitmapHeight;
            dx = (this.drawableRect.width() - (float)this.bitmapWidth * scale) * 0.5f;
        } else {
            scale = this.drawableRect.width() / (float)this.bitmapWidth;
            dy = (this.drawableRect.height() - (float)this.bitmapHeight * scale) * 0.5f;
        }
        this.shaderMatrix.setScale(scale, scale);
        this.shaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + this.drawableRect.left, (float)((int)(dy + 0.5f)) + this.drawableRect.top);
        this.bitmapShader.setLocalMatrix(this.shaderMatrix);
    }
}

