/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common;

import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.poller.Delay;
import com.helpshift.common.poller.HttpBackoff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AutoRetryFailedEventDM {
    private final Domain domain;
    private final Platform platform;
    private final HttpBackoff retryBackoff;
    private AtomicBoolean isBatcherScheduled = new AtomicBoolean(false);
    private Map<EventType, AutoRetriableDM> listeners = new HashMap<EventType, AutoRetriableDM>();
    private Set<EventType> pendingRetryEventTypes = Collections.synchronizedSet(new HashSet());

    public AutoRetryFailedEventDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.retryBackoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(5L, TimeUnit.SECONDS)).setMaxInterval(Delay.of(60L, TimeUnit.SECONDS)).setMaxAttempts(10).setRandomness(0.1f).setMultiplier(2.0f).setRetryPolicy(HttpBackoff.RetryPolicy.FAILURE).build();
    }

    public void register(EventType eventType, AutoRetriableDM autoRetriableDM) {
        this.listeners.put(eventType, autoRetriableDM);
    }

    public void scheduleRetryTaskForEventType(EventType eventType, int statusCode) {
        this.pendingRetryEventTypes.add(eventType);
        this.scheduleSync(statusCode);
    }

    public void sendAllEvents() {
        this.pendingRetryEventTypes.add(EventType.ACCOUNT);
        this.pendingRetryEventTypes.add(EventType.CONVERSATION);
        this.pendingRetryEventTypes.add(EventType.FAQ);
        this.pendingRetryEventTypes.add(EventType.ANALYTICS);
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                AutoRetryFailedEventDM.this.retryFailedApis();
            }
        });
    }

    private void scheduleSync(int statusCode) {
        if (this.isBatcherScheduled.compareAndSet(false, true)) {
            long nextInterval = this.retryBackoff.nextIntervalMillis(statusCode);
            if (nextInterval != -100L) {
                this.domain.runDelayedInParallel(new F(){

                    @Override
                    public void f() {
                        AutoRetryFailedEventDM.this.retryFailedApis();
                    }
                }, nextInterval);
            } else {
                this.isBatcherScheduled.compareAndSet(true, false);
            }
        }
    }

    void retryFailedApis() {
        this.isBatcherScheduled.compareAndSet(true, false);
        if (!this.platform.isOnline()) {
            this.scheduleSync(0);
            return;
        }
        ArrayList<EventType> eventTypes = new ArrayList<EventType>(this.pendingRetryEventTypes);
        try {
            for (EventType eventType : eventTypes) {
                AutoRetriableDM autoRetriableDM = this.listeners.get((Object)eventType);
                if (autoRetriableDM != null) {
                    autoRetriableDM.sendFailedApiCalls();
                }
                this.pendingRetryEventTypes.remove((Object)eventType);
            }
            this.retryBackoff.reset();
        }
        catch (RootAPIException ex) {
            int statusCode = ex.getServerStatusCode();
            this.scheduleSync(statusCode);
        }
    }

    public static enum EventType {
        ACCOUNT,
        CONVERSATION,
        FAQ,
        ANALYTICS;

    }
}

