/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.conversation;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import com.helpshift.common.conversation.ConversationDBInfo;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.AcceptedAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminMessageDM;
import com.helpshift.conversation.activeconversation.message.AttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.ConfirmationRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupAcceptedMessageDM;
import com.helpshift.conversation.activeconversation.message.FollowupRejectedMessageDM;
import com.helpshift.conversation.activeconversation.message.ImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.MessageType;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestForReopenMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.dto.ConversationStatus;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.dto.dao.ConversationInboxRecord;
import com.helpshift.conversation.states.ConversationCSATState;
import com.helpshift.platform.db.ConversationDBHelper;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationDB {
    private static final String TAG = "Helpshift_ConverDB";
    private final String KEY_CSAT_RATING = "csat_rating";
    private final String KEY_CSAT_STATE = "csat_state";
    private final String KEY_CSAT_FEEDBACK = "csat_feedback";
    private final String KEY_INCREMENT_MESSAGE_COUNT = "increment_message_count";
    private final String KEY_CONVERSATION_ENDED_DELEGATE_SENT = "ended_delegate_sent";
    private final String KEY_IMAGE_ATTACHMENT_DRAFT_ORIGINAL_NAME = "image_draft_orig_name";
    private final String KEY_IMAGE_ATTACHMENT_DRAFT_ORIGINAL_SIZE = "image_draft_orig_size";
    private final String KEY_IMAGE_ATTACHMENT_DRAFT_FILE_PATH = "image_draft_file_path";
    private final String KEY_IMAGE_ATTACHMENT_COMPRESSION_COPYING_DONE = "image_copy_done";
    private final String KEY_REFERRED_MESSAGE_ID = "referredMessageId";
    private final String KEY_FOLLOW_UP_REJECTED_REASON = "rejected_reason";
    private final String KEY_FOLLOW_UP_REJECTED_OPEN_CONVERSATION = "rejected_conv_id";
    private final String KEY_IS_ANSWERED = "is_answered";
    private final String KEY_CONTENT_TYPE = "content_type";
    private final String KEY_FILE_NAME = "file_name";
    private final String KEY_URL = "url";
    private final String KEY_SIZE = "size";
    private final String KEY_THUMBNAIL_URL = "thumbnail_url";
    private final String KEY_THUMBNAIL_FILE_PATH = "thumbnailFilePath";
    private final String KEY_FILE_PATH = "filePath";
    private final String KEY_CHAT_LAUNCH_SOURCE = "chat_launch_src";
    private final String KEY_SEEN_AT_MESSAGE_CURSOR = "seen_cursor";
    private final String KEY_SEEN_SYNC_STATUS = "seen_sync_status";
    private final String KEY_READ_AT = "read_at";
    private final ConversationDBInfo dbInfo = new ConversationDBInfo();
    private final ConversationDBHelper dbHelper;
    private static ConversationDB instance;

    private ConversationDB(Context context) {
        this.dbHelper = new ConversationDBHelper(context, this.dbInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConversationDB getInstance(Context context) {
        if (instance != null) return instance;
        Class<ConversationDB> clazz = ConversationDB.class;
        synchronized (ConversationDB.class) {
            if (instance != null) return instance;
            instance = new ConversationDB(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ConversationDM> readConversationsWithProfileId(long profileLocalId) {
        ArrayList<ConversationDM> conversations = new ArrayList<ConversationDM>();
        Cursor cursor = null;
        String selection = this.dbInfo.PROFILE_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(profileLocalId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATIONS, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    ConversationDM conversation = this.cursorToReadableConversation(cursor);
                    conversations.add(conversation);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversations with profileId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return conversations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConversationDM readConversationWithLocalId(Long localId) {
        ConversationDM conversation = null;
        Cursor cursor = null;
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATIONS, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                conversation = this.cursorToReadableConversation(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversations with localId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return conversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConversationDM readConversationWithServerId(String serverId) {
        ConversationDM conversation = null;
        Cursor cursor = null;
        String selection = this.dbInfo.SERVER_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(serverId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATIONS, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                conversation = this.cursorToReadableConversation(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversations with serverId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return conversation;
    }

    public synchronized long insertConversation(ConversationDM conversation) {
        ContentValues values = this.readableConversationToContentValues(conversation);
        long localId = -1L;
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            localId = database.insert(this.dbInfo.TABLE_CONVERSATIONS, null, values);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in insert conversation", ex);
        }
        return localId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Long> insertConversations(List<ConversationDM> conversations) {
        if (conversations.size() == 0) {
            return null;
        }
        ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>();
        for (ConversationDM conversation : conversations) {
            ContentValues values = this.readableConversationToContentValues(conversation);
            contentValues.add(values);
        }
        SQLiteDatabase database = null;
        ArrayList<Long> localIds = new ArrayList<Long>();
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (ContentValues contentValue : contentValues) {
                Long localId = database.insert(this.dbInfo.TABLE_CONVERSATIONS, null, contentValue);
                localIds.add(localId);
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in insert conversations", ex);
        }
        finally {
            if (database != null) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in insert conversations inside finally block", e);
                }
            }
        }
        return localIds;
    }

    public synchronized void updateConversation(ConversationDM conversation) {
        ContentValues values = this.readableConversationToContentValues(conversation);
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(conversation.localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.update(this.dbInfo.TABLE_CONVERSATIONS, values, selection, selectionArgs);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in update conversation", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateConversations(List<ConversationDM> conversations) {
        if (conversations.size() == 0) {
            return;
        }
        ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>();
        ArrayList<String[]> selectionArgs = new ArrayList<String[]>();
        for (ConversationDM conversation : conversations) {
            ContentValues values = this.readableConversationToContentValues(conversation);
            contentValues.add(values);
            String[] selectionArg = new String[]{String.valueOf(conversation.localId)};
            selectionArgs.add(selectionArg);
        }
        SQLiteDatabase database = null;
        String selection = this.dbInfo.ID + " = ?";
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (int i = 0; i < conversations.size(); ++i) {
                database.update(this.dbInfo.TABLE_CONVERSATIONS, (ContentValues)contentValues.get(i), selection, (String[])selectionArgs.get(i));
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in update conversations", ex);
        }
        finally {
            if (database != null) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in update conversations inside finally block", e);
                }
            }
        }
    }

    public synchronized ConversationInboxRecord storeConversationInboxRecord(ConversationInboxRecord record) {
        String selection = this.dbInfo.PROFILE_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(record.profileLocalId)};
        ContentValues values = this.conversationInboxRecordToContentValues(record);
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            boolean isRowExist = this.exists(database, this.dbInfo.TABLE_CONVERSATION_INBOX, selection, selectionArgs);
            if (isRowExist) {
                database.update(this.dbInfo.TABLE_CONVERSATION_INBOX, values, selection, selectionArgs);
            } else {
                database.insert(this.dbInfo.TABLE_CONVERSATION_INBOX, null, values);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in store conversation inbox record", ex);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConversationInboxRecord readConversationInboxRecord(long profileLocalId) {
        ConversationInboxRecord record = null;
        Cursor cursor = null;
        String selection = this.dbInfo.PROFILE_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(profileLocalId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query(this.dbInfo.TABLE_CONVERSATION_INBOX, null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                record = this.cursorToConversationInboxRecord(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read conversation inbox record", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return record;
    }

    public synchronized long insertMessage(MessageDM readableMessage) {
        ContentValues values = this.readableMessageToContentValues(readableMessage);
        long localId = -1L;
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            localId = database.insert("messages", null, values);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in insert message", ex);
        }
        return localId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Long> insertMessages(List<MessageDM> messageDMs) {
        if (messageDMs.size() == 0) {
            return null;
        }
        ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>();
        for (MessageDM messageDM : messageDMs) {
            ContentValues values = this.readableMessageToContentValues(messageDM);
            contentValues.add(values);
        }
        SQLiteDatabase database = null;
        ArrayList<Long> localIds = new ArrayList<Long>();
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (ContentValues contentValue : contentValues) {
                Long localId = database.insert("messages", null, contentValue);
                localIds.add(localId);
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in insert messages", ex);
        }
        finally {
            if (database != null) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in insert messages inside finally block", e);
                }
            }
        }
        return localIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<MessageDM> readMessages(long conversationLocalId) {
        ArrayList<MessageDM> readableMessages = new ArrayList<MessageDM>();
        Cursor cursor = null;
        String selection = this.dbInfo.CONVERSATION_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(conversationLocalId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query("messages", null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    MessageDM readableMessage = this.cursorToMessageDM(cursor);
                    readableMessages.add(readableMessage);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read messages", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return readableMessages;
    }

    public synchronized void updateMessage(MessageDM readableMessage) {
        ContentValues values = this.readableMessageToContentValues(readableMessage);
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(readableMessage.localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.update("messages", values, selection, selectionArgs);
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in update message", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateMessages(List<MessageDM> messageDMs) {
        if (messageDMs.size() == 0) {
            return;
        }
        ArrayList<ContentValues> contentValues = new ArrayList<ContentValues>();
        ArrayList<String[]> selectionArgs = new ArrayList<String[]>();
        for (MessageDM messageDM : messageDMs) {
            ContentValues values = this.readableMessageToContentValues(messageDM);
            contentValues.add(values);
            String[] selectionArg = new String[]{String.valueOf(messageDM.localId)};
            selectionArgs.add(selectionArg);
        }
        SQLiteDatabase database = null;
        String selection = this.dbInfo.ID + " = ?";
        try {
            database = this.dbHelper.getWritableDatabase();
            database.beginTransaction();
            for (int i = 0; i < messageDMs.size(); ++i) {
                database.update("messages", (ContentValues)contentValues.get(i), selection, (String[])selectionArgs.get(i));
            }
            database.setTransactionSuccessful();
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in update messages", ex);
        }
        finally {
            if (database != null) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    HSLogger.e(TAG, "Error in update messages", e);
                }
            }
        }
    }

    private boolean exists(SQLiteDatabase database, String table, String query, String[] selectionArgs) {
        return DatabaseUtils.longForQuery((SQLiteDatabase)database, (String)("SELECT COUNT(*) FROM " + table + " WHERE " + query + " LIMIT 1"), (String[])selectionArgs) > 0L;
    }

    private ConversationInboxRecord cursorToConversationInboxRecord(Cursor cursor) {
        long profileId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.PROFILE_ID));
        String formName = cursor.getString(cursor.getColumnIndex(this.dbInfo.FORM_NAME));
        String formEmail = cursor.getString(cursor.getColumnIndex(this.dbInfo.FORM_EMAIL));
        String description = cursor.getString(cursor.getColumnIndex(this.dbInfo.DESCRIPTION_DRAFT));
        long descriptionTimeStamp = cursor.getLong(cursor.getColumnIndex(this.dbInfo.DESCRIPTION_DRAFT_TIMESTAMP));
        String attachedDraftJson = cursor.getString(cursor.getColumnIndex(this.dbInfo.ATTACHMENT_DRAFT));
        ImagePickerFile imageAttachedDraft = this.parseAndGetImageAttachmentDraft(attachedDraftJson);
        int descriptionType = cursor.getInt(cursor.getColumnIndex(this.dbInfo.DESCRIPTION_TYPE));
        String archivedText = cursor.getString(cursor.getColumnIndex(this.dbInfo.ARCHIVAL_TEXT));
        String replyText = cursor.getString(cursor.getColumnIndex(this.dbInfo.REPLY_TEXT));
        boolean persistMessageBox = cursor.getInt(cursor.getColumnIndex(this.dbInfo.PERSIST_MESSAGE_BOX)) == 1;
        String inboxTimestamp = cursor.getString(cursor.getColumnIndex(this.dbInfo.LAST_SYNC_TIMESTAMP));
        return new ConversationInboxRecord(profileId, formName, formEmail, description, descriptionTimeStamp, imageAttachedDraft, descriptionType, archivedText, replyText, persistMessageBox, inboxTimestamp);
    }

    private ContentValues conversationInboxRecordToContentValues(ConversationInboxRecord record) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(this.dbInfo.PROFILE_ID, Long.valueOf(record.profileLocalId));
        contentValues.put(this.dbInfo.FORM_NAME, record.formName);
        contentValues.put(this.dbInfo.FORM_EMAIL, record.formEmail);
        contentValues.put(this.dbInfo.DESCRIPTION_DRAFT, record.description);
        contentValues.put(this.dbInfo.DESCRIPTION_DRAFT_TIMESTAMP, Long.valueOf(record.descriptionTimeStamp));
        contentValues.put(this.dbInfo.DESCRIPTION_TYPE, Integer.valueOf(record.descriptionType));
        contentValues.put(this.dbInfo.ARCHIVAL_TEXT, record.archivalText);
        contentValues.put(this.dbInfo.REPLY_TEXT, record.replyText);
        contentValues.put(this.dbInfo.PERSIST_MESSAGE_BOX, Integer.valueOf(record.persistMessageBox ? 1 : 0));
        contentValues.put(this.dbInfo.LAST_SYNC_TIMESTAMP, record.lastSyncTimestamp);
        try {
            String imageAttachmentDraft = this.getImageAttachmentDraftMeta(record.imageAttachmentDraft);
            contentValues.put(this.dbInfo.ATTACHMENT_DRAFT, imageAttachmentDraft);
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Error in generating meta string for image attachment", e);
        }
        return contentValues;
    }

    private ContentValues readableConversationToContentValues(ConversationDM conversation) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(this.dbInfo.PROFILE_ID, Long.valueOf(conversation.profileLocalId));
        contentValues.put(this.dbInfo.SERVER_ID, conversation.serverId);
        contentValues.put(this.dbInfo.PUBLISH_ID, conversation.publishId);
        contentValues.put(this.dbInfo.TITLE, conversation.title);
        contentValues.put(this.dbInfo.STATUS, Integer.valueOf(conversation.status.getValue()));
        contentValues.put(this.dbInfo.MESSAGE_CURSOR, conversation.messageCursor);
        contentValues.put(this.dbInfo.SHOW_AGENT_NAME, Integer.valueOf(conversation.showAgentName ? 1 : 0));
        contentValues.put(this.dbInfo.IS_START_NEW_CONVERSATION_CLICKED, Integer.valueOf(conversation.isStartNewConversationClicked ? 1 : 0));
        contentValues.put(this.dbInfo.CREATED_AT, conversation.createdAt);
        contentValues.put(this.dbInfo.UPDATED_AT, conversation.updatedAt);
        try {
            String conversationMeta = this.getConversationMeta(conversation);
            contentValues.put("meta", conversationMeta);
        }
        catch (JSONException jsonException) {
            HSLogger.e(TAG, "Error in generating meta string for conversation", jsonException);
        }
        return contentValues;
    }

    private String getImageAttachmentDraftMeta(ImagePickerFile imagePickerFile) throws JSONException {
        if (imagePickerFile == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("image_draft_orig_name", (Object)imagePickerFile.originalFileName);
        jsonObject.put("image_draft_orig_size", (Object)imagePickerFile.originalFileSize);
        jsonObject.put("image_draft_file_path", (Object)imagePickerFile.filePath);
        jsonObject.put("image_copy_done", imagePickerFile.isFileCompressionAndCopyingDone);
        return jsonObject.toString();
    }

    private String getConversationMeta(ConversationDM conversation) throws JSONException {
        ConversationCSATState csatState = conversation.csatState;
        JSONObject jsonObject = new JSONObject();
        String csatFeedback = conversation.csatFeedback;
        int csatRating = conversation.csatRating;
        jsonObject.put("csat_feedback", (Object)csatFeedback);
        jsonObject.put("csat_rating", csatRating);
        jsonObject.put("csat_state", csatState.getValue());
        jsonObject.put("increment_message_count", conversation.shouldIncrementMessageCount);
        jsonObject.put("ended_delegate_sent", conversation.isConversationEndedDelegateSent);
        return jsonObject.toString();
    }

    private ConversationDM cursorToReadableConversation(Cursor cursor) {
        Long localId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.ID));
        long profileId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.PROFILE_ID));
        String serverId = cursor.getString(cursor.getColumnIndex(this.dbInfo.SERVER_ID));
        String publishId = cursor.getString(cursor.getColumnIndex(this.dbInfo.PUBLISH_ID));
        String title = cursor.getString(cursor.getColumnIndex(this.dbInfo.TITLE));
        int status = cursor.getInt(cursor.getColumnIndex(this.dbInfo.STATUS));
        int showAgentNameValue = cursor.getInt(cursor.getColumnIndex(this.dbInfo.SHOW_AGENT_NAME));
        boolean showAgentName = showAgentNameValue == 1;
        String messageCursor = cursor.getString(cursor.getColumnIndex(this.dbInfo.MESSAGE_CURSOR));
        int startNewConversationValue = cursor.getInt(cursor.getColumnIndex(this.dbInfo.IS_START_NEW_CONVERSATION_CLICKED));
        boolean startNewConversationAction = startNewConversationValue == 1;
        String meta = cursor.getString(cursor.getColumnIndex("meta"));
        String createdAt = cursor.getString(cursor.getColumnIndex(this.dbInfo.CREATED_AT));
        String updatedAt = cursor.getString(cursor.getColumnIndex(this.dbInfo.UPDATED_AT));
        ConversationDM conversationDM = new ConversationDM(serverId, title, ConversationStatus.fromInt(status), createdAt, updatedAt, publishId, messageCursor, showAgentName);
        conversationDM.setLocalId(localId);
        conversationDM.profileLocalId = profileId;
        conversationDM.setStartNewConversationButtonClicked(startNewConversationAction, false);
        this.parseAndSetMetaData(conversationDM, meta);
        return conversationDM;
    }

    private ContentValues readableMessageToContentValues(MessageDM messageDM) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(this.dbInfo.SERVER_ID, messageDM.serverId);
        contentValues.put(this.dbInfo.CONVERSATION_ID, messageDM.conversationLocalId);
        contentValues.put(this.dbInfo.BODY, messageDM.body);
        contentValues.put(this.dbInfo.AUTHOR_NAME, messageDM.authorName);
        contentValues.put(this.dbInfo.CREATED_AT, messageDM.createdAt);
        contentValues.put(this.dbInfo.TYPE, messageDM.messageType.getValue());
        contentValues.put(this.dbInfo.DELIVERY_STATE, Integer.valueOf(messageDM.deliveryState));
        try {
            contentValues.put(this.dbInfo.MESSAGE_META, this.getMessageMeta(messageDM));
        }
        catch (JSONException jsonException) {
            HSLogger.e(TAG, "Error in generating meta string for message", jsonException);
        }
        return contentValues;
    }

    private void parseAndSetMetaData(ConversationDM conversationDM, String meta) {
        if (meta == null) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(meta);
            int csatRating = jsonObject.optInt("csat_rating", 0);
            int csatState = jsonObject.optInt("csat_state", ConversationCSATState.NONE.getValue());
            String csatFeedback = jsonObject.optString("csat_feedback", null);
            conversationDM.setCSATData(csatRating, ConversationCSATState.fromInt(csatState), csatFeedback);
            boolean increaseMessageCount = jsonObject.optBoolean("increment_message_count", false);
            conversationDM.setShouldIncrementMessageCount(increaseMessageCount, false);
            conversationDM.isConversationEndedDelegateSent = jsonObject.optBoolean("ended_delegate_sent", false);
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Error in parseAndSetMetaData", e);
        }
    }

    private ImagePickerFile parseAndGetImageAttachmentDraft(String meta) {
        if (meta == null) {
            return null;
        }
        ImagePickerFile imagePickerFile = null;
        try {
            JSONObject jsonObject = new JSONObject(meta);
            String originalName = jsonObject.optString("image_draft_orig_name", null);
            Long originalSize = jsonObject.optLong("image_draft_orig_size", -1L);
            String filePath = jsonObject.optString("image_draft_file_path", null);
            boolean isFileCopyingDone = jsonObject.optBoolean("image_copy_done", false);
            imagePickerFile = new ImagePickerFile(filePath, originalName, originalSize == -1L ? null : originalSize);
            imagePickerFile.isFileCompressionAndCopyingDone = isFileCopyingDone;
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Error in parseAndGetImageAttachmentDraft", e);
        }
        return imagePickerFile;
    }

    private MessageDM cursorToMessageDM(Cursor cursor) {
        MessageDM messageDM;
        long localId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.ID));
        long conversationLocalId = cursor.getLong(cursor.getColumnIndex(this.dbInfo.CONVERSATION_ID));
        String serverId = cursor.getString(cursor.getColumnIndex(this.dbInfo.SERVER_ID));
        String body = cursor.getString(cursor.getColumnIndex(this.dbInfo.BODY));
        String authorName = cursor.getString(cursor.getColumnIndex(this.dbInfo.AUTHOR_NAME));
        String metaText = cursor.getString(cursor.getColumnIndex(this.dbInfo.MESSAGE_META));
        String type = cursor.getString(cursor.getColumnIndex(this.dbInfo.TYPE));
        String createAt = cursor.getString(cursor.getColumnIndex(this.dbInfo.CREATED_AT));
        int deliveryState = cursor.getInt(cursor.getColumnIndex(this.dbInfo.DELIVERY_STATE));
        MessageType messageType = MessageType.fromValue(type);
        JSONObject metaJson = this.jsonify(metaText);
        switch (messageType) {
            case USER_TEXT: {
                messageDM = new UserMessageDM(body, createAt, authorName);
                messageDM.serverId = serverId;
                break;
            }
            case ADMIN_TEXT: {
                messageDM = new AdminMessageDM(serverId, body, createAt, authorName);
                break;
            }
            case ACCEPTED_APP_REVIEW: {
                messageDM = new AcceptedAppReviewMessageDM(body, createAt, authorName, this.parseReferredMessageIdFromMeta(metaJson));
                messageDM.serverId = serverId;
                break;
            }
            case REQUESTED_APP_REVIEW: {
                messageDM = new RequestAppReviewMessageDM(serverId, body, createAt, authorName, this.parseIsAnsweredFromMeta(metaJson));
                break;
            }
            case FOLLOWUP_ACCEPTED: {
                messageDM = new FollowupAcceptedMessageDM(body, createAt, authorName, this.parseReferredMessageIdFromMeta(metaJson));
                messageDM.serverId = serverId;
                break;
            }
            case FOLLOWUP_REJECTED: {
                messageDM = new FollowupRejectedMessageDM(body, createAt, authorName, this.parseReferredMessageIdFromMeta(metaJson));
                messageDM.serverId = serverId;
                this.parseAndSetFollowUpRejectedDataFromMeta((FollowupRejectedMessageDM)messageDM, metaJson);
                break;
            }
            case CONFIRMATION_ACCEPTED: {
                messageDM = new ConfirmationAcceptedMessageDM(body, createAt, authorName);
                messageDM.serverId = serverId;
                break;
            }
            case CONFIRMATION_REJECTED: {
                messageDM = new ConfirmationRejectedMessageDM(body, createAt, authorName);
                messageDM.serverId = serverId;
                break;
            }
            case SCREENSHOT: {
                ImageAttachmentInfo imageAttachmentInfo = this.parseImageAttachmentInfoFromMeta(metaJson);
                ScreenshotMessageDM screenshotMessageDM = new ScreenshotMessageDM(body, createAt, authorName, imageAttachmentInfo.contentType, imageAttachmentInfo.thumbnailUrl, imageAttachmentInfo.fileName, imageAttachmentInfo.url, imageAttachmentInfo.size);
                screenshotMessageDM.filePath = imageAttachmentInfo.filePath;
                screenshotMessageDM.serverId = serverId;
                screenshotMessageDM.setRefersMessageId(this.parseReferredMessageIdFromMeta(metaJson));
                messageDM = screenshotMessageDM;
                break;
            }
            case REQUESTED_SCREENSHOT: {
                messageDM = new RequestScreenshotMessageDM(serverId, body, createAt, authorName, this.parseIsAnsweredFromMeta(metaJson));
                break;
            }
            case ADMIN_ATTACHMENT: {
                AttachmentInfo attachmentInfo = this.parseAttachmentInfoFromMeta(metaJson);
                AdminAttachmentMessageDM adminAttachmentMessageDM = new AdminAttachmentMessageDM(serverId, body, createAt, authorName, attachmentInfo.size, attachmentInfo.contentType, attachmentInfo.url, attachmentInfo.fileName);
                adminAttachmentMessageDM.filePath = attachmentInfo.filePath;
                adminAttachmentMessageDM.updateState();
                messageDM = adminAttachmentMessageDM;
                break;
            }
            case ADMIN_IMAGE_ATTACHMENT: {
                ImageAttachmentInfo imageAttachmentInfo = this.parseImageAttachmentInfoFromMeta(metaJson);
                AdminImageAttachmentMessageDM adminImageAttachmentMessageDM = new AdminImageAttachmentMessageDM(serverId, body, createAt, authorName, imageAttachmentInfo.url, imageAttachmentInfo.fileName, imageAttachmentInfo.thumbnailUrl, imageAttachmentInfo.contentType, imageAttachmentInfo.size);
                adminImageAttachmentMessageDM.filePath = imageAttachmentInfo.filePath;
                adminImageAttachmentMessageDM.thumbnailFilePath = imageAttachmentInfo.thumbnailFilePath;
                adminImageAttachmentMessageDM.updateState();
                messageDM = adminImageAttachmentMessageDM;
                break;
            }
            case REQUEST_FOR_REOPEN: {
                RequestForReopenMessageDM requestForReopenMessageDM = new RequestForReopenMessageDM(serverId, body, createAt, authorName);
                requestForReopenMessageDM.isAnswered = this.parseIsAnsweredFromMeta(metaJson);
                messageDM = requestForReopenMessageDM;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Message type not supported");
            }
        }
        messageDM.conversationLocalId = conversationLocalId;
        messageDM.localId = localId;
        messageDM.deliveryState = deliveryState;
        this.parseAndSetMessageSeenData(messageDM, metaJson);
        return messageDM;
    }

    private void parseAndSetMessageSeenData(MessageDM messageDM, JSONObject meta) {
        if (meta == null) {
            return;
        }
        String readAt = meta.optString("read_at", "");
        String seenAtMessageCursor = meta.optString("seen_cursor", null);
        String chatLaunchSource = meta.optString("chat_launch_src", null);
        boolean seenSyncStatus = meta.optBoolean("seen_sync_status", false);
        messageDM.seenAtMessageCursor = seenAtMessageCursor;
        messageDM.chatLaunchSource = chatLaunchSource;
        messageDM.isMessageSeenSynced = seenSyncStatus;
        messageDM.readAt = readAt;
    }

    private JSONObject jsonify(String data) {
        if (data == null) {
            return null;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private String parseReferredMessageIdFromMeta(JSONObject meta) {
        if (meta == null) {
            return null;
        }
        return meta.optString("referredMessageId", null);
    }

    private boolean parseIsAnsweredFromMeta(JSONObject meta) {
        if (meta == null) {
            return false;
        }
        return meta.optBoolean("is_answered", false);
    }

    private AttachmentInfo parseAttachmentInfoFromMeta(JSONObject meta) {
        if (meta == null) {
            return null;
        }
        return new AttachmentInfo(meta);
    }

    private ImageAttachmentInfo parseImageAttachmentInfoFromMeta(JSONObject meta) {
        if (meta == null) {
            return null;
        }
        return new ImageAttachmentInfo(meta);
    }

    private void parseAndSetFollowUpRejectedDataFromMeta(FollowupRejectedMessageDM messageDM, JSONObject meta) {
        if (meta == null) {
            return;
        }
        int reason = meta.optInt("rejected_reason");
        String activeConversationId = meta.optString("rejected_conv_id", null);
        messageDM.reason = reason;
        messageDM.openConversationId = activeConversationId;
    }

    private String getMessageMeta(MessageDM messageDM) throws JSONException {
        MessageType messageType = messageDM.messageType;
        JSONObject result = null;
        switch (messageType) {
            case ADMIN_TEXT: {
                result = new JSONObject();
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case ACCEPTED_APP_REVIEW: {
                result = new JSONObject();
                AcceptedAppReviewMessageDM acceptedReviewMessage = (AcceptedAppReviewMessageDM)messageDM;
                this.buildMetaForReferredMessageId(result, acceptedReviewMessage.referredMessageId);
                break;
            }
            case REQUESTED_SCREENSHOT: {
                result = new JSONObject();
                RequestScreenshotMessageDM requestScreenshotMessage = (RequestScreenshotMessageDM)messageDM;
                this.buildMetaForIsAnswered(result, requestScreenshotMessage.isAnswered);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case REQUEST_FOR_REOPEN: {
                result = new JSONObject();
                RequestForReopenMessageDM requestForReopenMessageDM = (RequestForReopenMessageDM)messageDM;
                this.buildMetaForIsAnswered(result, requestForReopenMessageDM.isAnswered);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case FOLLOWUP_ACCEPTED: {
                result = new JSONObject();
                FollowupAcceptedMessageDM followupAcceptedMessage = (FollowupAcceptedMessageDM)messageDM;
                this.buildMetaForReferredMessageId(result, followupAcceptedMessage.referredMessageId);
                break;
            }
            case FOLLOWUP_REJECTED: {
                result = new JSONObject();
                this.buildMetaForFollowUpRejected(result, (FollowupRejectedMessageDM)messageDM);
                break;
            }
            case REQUESTED_APP_REVIEW: {
                result = new JSONObject();
                RequestAppReviewMessageDM requestAppReviewMessage = (RequestAppReviewMessageDM)messageDM;
                this.buildMetaForIsAnswered(result, requestAppReviewMessage.isAnswered);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case ADMIN_ATTACHMENT: {
                result = new JSONObject();
                AttachmentMessageDM adminAttachmentMessage = (AttachmentMessageDM)messageDM;
                this.buildJsonObjectForAttachmentMessage(result, adminAttachmentMessage);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case ADMIN_IMAGE_ATTACHMENT: {
                result = new JSONObject();
                this.buildMetaForImageAttachmentMessage(result, (ImageAttachmentMessageDM)messageDM);
                this.buildMetaForMessageSeenData(result, messageDM);
                break;
            }
            case SCREENSHOT: {
                result = new JSONObject();
                this.buildMetaForScreenshotAttachmentMessage(result, (ScreenshotMessageDM)messageDM);
            }
        }
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    private void buildMetaForMessageSeenData(JSONObject jsonObject, MessageDM messageDM) throws JSONException {
        jsonObject.put("seen_cursor", (Object)messageDM.seenAtMessageCursor);
        jsonObject.put("chat_launch_src", (Object)messageDM.chatLaunchSource);
        jsonObject.put("seen_sync_status", messageDM.isMessageSeenSynced);
        jsonObject.put("read_at", (Object)messageDM.readAt);
    }

    private void buildMetaForReferredMessageId(JSONObject jsonObject, String referredMessageId) throws JSONException {
        jsonObject.put("referredMessageId", (Object)referredMessageId);
    }

    private void buildMetaForFollowUpRejected(JSONObject jsonObject, FollowupRejectedMessageDM followupRejectedMessage) throws JSONException {
        jsonObject.put("referredMessageId", (Object)followupRejectedMessage.referredMessageId);
        jsonObject.put("rejected_reason", followupRejectedMessage.reason);
        jsonObject.put("rejected_conv_id", (Object)followupRejectedMessage.openConversationId);
    }

    private void buildMetaForIsAnswered(JSONObject jsonObject, boolean isAnswered) throws JSONException {
        jsonObject.put("is_answered", isAnswered);
    }

    private void buildJsonObjectForAttachmentMessage(JSONObject jsonObject, AttachmentMessageDM attachmentMessage) throws JSONException {
        jsonObject.put("content_type", (Object)attachmentMessage.contentType);
        jsonObject.put("file_name", (Object)attachmentMessage.fileName);
        jsonObject.put("filePath", (Object)attachmentMessage.filePath);
        jsonObject.put("url", (Object)attachmentMessage.attachmentUrl);
        jsonObject.put("size", attachmentMessage.size);
    }

    private void buildMetaForScreenshotAttachmentMessage(JSONObject jsonObject, ScreenshotMessageDM message) throws JSONException {
        this.buildJsonObjectForAttachmentMessage(jsonObject, message);
        jsonObject.put("thumbnail_url", (Object)message.thumbnailUrl);
        jsonObject.put("referredMessageId", (Object)message.refersMessageId);
    }

    private void buildMetaForImageAttachmentMessage(JSONObject jsonObject, ImageAttachmentMessageDM imageAttachmentMessage) throws JSONException {
        this.buildJsonObjectForAttachmentMessage(jsonObject, imageAttachmentMessage);
        jsonObject.put("thumbnail_url", (Object)imageAttachmentMessage.thumbnailUrl);
        jsonObject.put("thumbnailFilePath", (Object)imageAttachmentMessage.thumbnailFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageDM readMessageWithServerId(String serverId) {
        MessageDM message = null;
        Cursor cursor = null;
        String selection = this.dbInfo.SERVER_ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(serverId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query("messages", null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                message = this.cursorToMessageDM(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read message with serverId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageDM readMessageWithLocalId(Long localId) {
        MessageDM message = null;
        Cursor cursor = null;
        String selection = this.dbInfo.ID + " = ?";
        String[] selectionArgs = new String[]{String.valueOf(localId)};
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query("messages", null, selection, selectionArgs, null, null, null);
            if (cursor.moveToFirst()) {
                message = this.cursorToMessageDM(cursor);
            }
        }
        catch (Exception ex) {
            HSLogger.e(TAG, "Error in read message with localId", ex);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return message;
    }

    public synchronized void dropAndCreateDatabase() {
        this.dbHelper.dropAndCreateDatabase(this.dbHelper.getWritableDatabase());
    }

    private class AttachmentInfo {
        final String contentType;
        final String fileName;
        final String url;
        final String filePath;
        final int size;

        AttachmentInfo(JSONObject jsonObject) {
            this.fileName = jsonObject.optString("file_name", null);
            this.contentType = jsonObject.optString("content_type", null);
            this.url = jsonObject.optString("url", null);
            this.size = jsonObject.optInt("size", 0);
            this.filePath = jsonObject.optString("filePath", null);
        }
    }

    private class ImageAttachmentInfo
    extends AttachmentInfo {
        final String thumbnailUrl;
        final String thumbnailFilePath;

        ImageAttachmentInfo(JSONObject jsonObject) {
            super(jsonObject);
            this.thumbnailUrl = jsonObject.optString("thumbnail_url", null);
            this.thumbnailFilePath = jsonObject.optString("thumbnailFilePath", null);
        }
    }
}

