/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.conversation.dto.ImagePickerFile;
import java.io.File;

public class AttachmentFileManagerDM {
    private Domain domain;
    Platform platform;
    public static final String LOCAL_RSC_MESSAGE_PREFIX = "localRscMessage_";

    public AttachmentFileManagerDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
    }

    public void compressAndCopyScreenshot(final ImagePickerFile imagePickerFile, final String refersId, final Listener listener) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                try {
                    AttachmentFileManagerDM.this.platform.compressAndCopyScreenshot(imagePickerFile, refersId);
                    listener.onCompressAndCopySuccess(imagePickerFile);
                }
                catch (RootAPIException e) {
                    listener.onCompressAndCopyFailure(e);
                    throw e;
                }
            }
        });
    }

    public void deleteAttachmentLocalCopy(ImagePickerFile imagePickerFile) {
        if (imagePickerFile != null && imagePickerFile.filePath != null && imagePickerFile.isFileCompressionAndCopyingDone) {
            new File(imagePickerFile.filePath).delete();
        }
    }

    public static interface Listener {
        public void onCompressAndCopyFailure(RootAPIException var1);

        public void onCompressAndCopySuccess(ImagePickerFile var1);
    }
}

