/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain;

import com.helpshift.common.domain.DelayedThreader;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.logger.logmodels.ILogExtrasModel;
import com.helpshift.logger.logmodels.LogExtrasModelProvider;
import com.helpshift.util.HSLogger;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class BackgroundDelayedThreader
implements DelayedThreader {
    final ScheduledExecutorService service;
    private static final String TAG = "Helpshift_CoreDelayTh";

    BackgroundDelayedThreader(ScheduledExecutorService service) {
        this.service = service;
    }

    @Override
    public F thread(final F f, final long delayInMillis) {
        return new F(){

            @Override
            public void f() {
                f.cause = new Throwable();
                try {
                    BackgroundDelayedThreader.this.service.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                f.f();
                            }
                            catch (RootAPIException rootAPIException) {
                                if (rootAPIException.shouldLog()) {
                                    String message;
                                    ILogExtrasModel logExtrasModel = null;
                                    String string2 = message = rootAPIException.message == null ? "" : rootAPIException.message;
                                    if (rootAPIException.exceptionType instanceof NetworkException) {
                                        String route = ((NetworkException)rootAPIException.exceptionType).route;
                                        logExtrasModel = LogExtrasModelProvider.fromString("route", route);
                                    }
                                    HSLogger.e(BackgroundDelayedThreader.TAG, message, new Throwable[]{rootAPIException.exception, f.cause}, logExtrasModel);
                                }
                            }
                            catch (Exception e) {
                                String message = "Caught unhandled exception inside BackgroundThreader";
                                HSLogger.f(BackgroundDelayedThreader.TAG, message, new Throwable[]{e, f.cause}, new ILogExtrasModel[0]);
                            }
                        }
                    }, delayInMillis, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    HSLogger.e(BackgroundDelayedThreader.TAG, "Rejected execution of task in BackgroundDelayedThreader", e);
                }
            }
        };
    }
}

