/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.RF;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.poller.Delay;
import com.helpshift.common.poller.HttpBackoff;
import java.util.concurrent.TimeUnit;

public class Poller {
    private final Domain domain;
    private final F aggressivePollFunction;
    private final F conservativePollFunction;
    boolean started = false;
    boolean isConservativePollScheduled;
    boolean isAggressivePollScheduled;
    public ActivePollingInterval interval = null;

    public Poller(Domain domain, RF<Integer> rf) {
        this.domain = domain;
        this.aggressivePollFunction = this.createAggressivePollFunction(rf);
        this.conservativePollFunction = this.createConservativePollFunction(rf);
    }

    public synchronized void start(ActivePollingInterval interval) {
        this.started = true;
        this.switchIntervalAndStartPolling(interval);
    }

    public synchronized void stop() {
        this.started = false;
        this.interval = null;
    }

    private void switchIntervalAndStartPolling(ActivePollingInterval newInterval) {
        if (newInterval != null && !newInterval.equals((Object)this.interval)) {
            this.interval = newInterval;
            switch (newInterval) {
                case AGGRESSIVE: {
                    this.scheduleAggressivePoll(0L);
                    break;
                }
                case CONSERVATIVE: {
                    this.scheduleConservativePoll(0L);
                }
            }
        }
    }

    void scheduleConservativePoll(long afterDelay) {
        if (!this.isConservativePollScheduled) {
            this.isConservativePollScheduled = true;
            this.domain.runDelayedInParallel(this.conservativePollFunction, afterDelay);
        }
    }

    void scheduleAggressivePoll(long afterDelay) {
        if (!this.isAggressivePollScheduled) {
            this.isAggressivePollScheduled = true;
            this.domain.runDelayedInParallel(this.aggressivePollFunction, afterDelay);
        }
    }

    private F createConservativePollFunction(final RF<Integer> rf) {
        return new F(){
            private HttpBackoff backoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(5L, TimeUnit.SECONDS)).setMaxInterval(Delay.of(1L, TimeUnit.MINUTES)).setRandomness(0.1f).setMultiplier(2.0f).setRetryPolicy(HttpBackoff.RetryPolicy.FAILURE).build();

            @Override
            public void f() {
                Poller.this.isConservativePollScheduled = false;
                if (Poller.this.started && Poller.this.interval == ActivePollingInterval.CONSERVATIVE) {
                    long nextDelay;
                    int responseCode;
                    try {
                        responseCode = (Integer)rf.f();
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType instanceof NetworkException) {
                            responseCode = NetworkErrorCodes.GENERIC_NETWORK_ERROR;
                        }
                        throw e;
                    }
                    if (responseCode == NetworkErrorCodes.OK) {
                        this.backoff.reset();
                    }
                    if ((nextDelay = this.backoff.nextIntervalMillis(responseCode)) != -100L) {
                        Poller.this.scheduleConservativePoll(nextDelay);
                    }
                } else {
                    this.backoff.reset();
                }
            }
        };
    }

    private F createAggressivePollFunction(final RF<Integer> rf) {
        return new F(){
            private HttpBackoff backoff = new HttpBackoff.Builder().setBaseInterval(Delay.of(3L, TimeUnit.SECONDS)).setMaxInterval(Delay.of(3L, TimeUnit.SECONDS)).setRandomness(0.0f).setMultiplier(1.0f).setRetryPolicy(HttpBackoff.RetryPolicy.FAILURE).build();

            @Override
            public void f() {
                Poller.this.isAggressivePollScheduled = false;
                if (Poller.this.started && Poller.this.interval == ActivePollingInterval.AGGRESSIVE) {
                    long nextDelay;
                    int responseCode;
                    try {
                        responseCode = (Integer)rf.f();
                    }
                    catch (RootAPIException e) {
                        if (e.exceptionType instanceof NetworkException) {
                            responseCode = NetworkErrorCodes.GENERIC_NETWORK_ERROR;
                        }
                        throw e;
                    }
                    if (responseCode == NetworkErrorCodes.OK) {
                        this.backoff.reset();
                    }
                    if ((nextDelay = this.backoff.nextIntervalMillis(responseCode)) != -100L) {
                        Poller.this.scheduleAggressivePoll(nextDelay);
                    }
                } else {
                    this.backoff.reset();
                }
            }
        };
    }

    public static enum ActivePollingInterval {
        AGGRESSIVE,
        CONSERVATIVE;

    }
}

