/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.HTTPTransport;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.common.platform.network.Request;
import com.helpshift.common.platform.network.Response;
import com.helpshift.crypto.CryptoDM;
import com.helpshift.localeprovider.domainmodel.LocaleProviderDM;
import java.security.GeneralSecurityException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

abstract class BaseNetwork
implements Network {
    final String route;
    final NetworkRequestDAO networkRequestDAO;
    private final HTTPTransport transport;
    private final String apiKey;
    private final LocaleProviderDM localeProviderDM;
    private final CryptoDM cryptoDM;
    private final String domainKey;
    private final String appId;
    private final Device device;
    private final Jsonifier jsonifier;

    BaseNetwork(String route, Domain domain, Platform platform) {
        this.route = route;
        this.localeProviderDM = domain.getLocaleProviderDM();
        this.cryptoDM = domain.getCryptoDM();
        this.networkRequestDAO = platform.getNetworkRequestDAO();
        this.transport = platform.getHTTPTransport();
        this.apiKey = platform.getAPIKey();
        this.domainKey = platform.getDomain();
        this.appId = platform.getAppId();
        this.device = platform.getDevice();
        this.jsonifier = platform.getJsonifier();
    }

    abstract Request getRequest(Map<String, String> var1);

    Map<String, String> cleanData(Map<String, String> data) {
        HashMap<String, String> cleanData = new HashMap<String, String>();
        for (String key : data.keySet()) {
            String value;
            if (key == null || (value = data.get(key)) == null) continue;
            cleanData.put(key, value);
        }
        return cleanData;
    }

    protected String getURL() {
        return NetworkConstants.scheme + this.domainKey + this.getURI();
    }

    private String getURI() {
        return "/api/lib/2" + this.route;
    }

    private String getAdjustedTimestamp() {
        float timeDelta = this.networkRequestDAO.getServerTimeDelta();
        DecimalFormat secondsFormatter = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        double deviceTs = System.currentTimeMillis() / 1000L;
        return secondsFormatter.format(deviceTs + (double)timeDelta);
    }

    Map<String, String> getAuthData(Method method, Map<String, String> data) {
        data.put("platform-id", this.appId);
        data.put("method", method.name());
        data.put("uri", this.getURI());
        data.put("timestamp", this.getAdjustedTimestamp());
        data.put("sm", this.getSdkMeta());
        ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
        Collections.sort(mapKeys);
        ArrayList<String> dataList = new ArrayList<String>();
        for (String key : mapKeys) {
            if (key.equals("screenshot") || key.equals("meta") || key.equals("originalFileName")) continue;
            dataList.add(key + "=" + data.get(key));
        }
        try {
            data.put("signature", this.cryptoDM.getSignature(this.join("&", dataList), this.apiKey));
        }
        catch (GeneralSecurityException e) {
            NetworkException networkException = NetworkException.UNABLE_TO_GENERATE_SIGNATURE;
            networkException.route = this.route;
            throw RootAPIException.wrap(e, networkException, "Network error");
        }
        data.remove("method");
        data.remove("uri");
        return data;
    }

    private String getSdkMeta() {
        HashMap<String, Object> sdkMetaMap = new HashMap<String, Object>();
        sdkMetaMap.put("ia", true);
        sdkMetaMap.put("rs", true);
        sdkMetaMap.put("clc", true);
        sdkMetaMap.put("atai", true);
        sdkMetaMap.put("fp", true);
        return this.jsonifier.jsonify(sdkMetaMap);
    }

    String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    List<KeyValuePair> getCommonHeaders() {
        String userAgent = String.format(Locale.ENGLISH, "Helpshift-%s/%s/%s", this.device.getPlatformName(), this.device.getSDKVersion(), this.device.getOSVersion());
        String acceptLangHead = String.format(Locale.ENGLISH, "%s;q=1.0", this.localeProviderDM.getAcceptLanguageHeader());
        String xHSVHead = String.format(Locale.ENGLISH, "Helpshift-%s/%s", this.device.getPlatformName(), this.device.getSDKVersion());
        ArrayList<KeyValuePair> headers = new ArrayList<KeyValuePair>();
        headers.add(new KeyValuePair("User-Agent", userAgent));
        headers.add(new KeyValuePair("Accept-Language", acceptLangHead));
        headers.add(new KeyValuePair("Accept-Encoding", "gzip"));
        headers.add(new KeyValuePair("X-HS-V", xHSVHead));
        return headers;
    }

    @Override
    public Response makeRequest(Map<String, String> data) {
        return this.transport.makeRequest(this.getRequest(data));
    }
}

