/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.common.platform.network.Response;
import java.util.List;
import java.util.Map;

public class ETagNetwork
implements Network {
    private final Network network;
    private final NetworkRequestDAO networkRequestDAO;
    private final String route;

    public ETagNetwork(Network network, Platform platform, String route) {
        this.network = network;
        this.networkRequestDAO = platform.getNetworkRequestDAO();
        this.route = route;
    }

    @Override
    public Response makeRequest(Map<String, String> data) {
        String eTag;
        Response response = this.network.makeRequest(data);
        int status = response.status;
        if (status >= 200 && status < 300 && (eTag = this.getHeaderValue(response.headers, "ETag")) != null) {
            this.networkRequestDAO.storeETag(this.route, eTag);
        }
        return response;
    }

    private String getHeaderValue(List<KeyValuePair> headers, String key) {
        String value = null;
        for (KeyValuePair header : headers) {
            if (header.key == null || !header.key.equals(key)) continue;
            value = header.value;
            break;
        }
        return value;
    }
}

