/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.NetworkErrorCodes;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.Response;
import java.util.HashMap;
import java.util.Map;

public class FailedAPICallNetworkDecorator
implements Network {
    private final Network network;

    public FailedAPICallNetworkDecorator(Network network) {
        this.network = network;
    }

    @Override
    public Response makeRequest(Map<String, String> data) {
        Response response = this.network.makeRequest(new HashMap<String, String>(data));
        int status = response.status;
        if (this.isStatusCodeNonRetriable(status)) {
            NetworkException networkException = NetworkException.NON_RETRIABLE;
            networkException.serverStatusCode = status;
            throw RootAPIException.wrap(null, networkException);
        }
        return response;
    }

    private boolean isStatusCodeNonRetriable(int status) {
        return NetworkErrorCodes.NOT_RETRIABLE_STATUS_CODES.contains(status);
    }
}

