/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.BaseNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.GETRequest;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GETNetwork
extends BaseNetwork {
    public GETNetwork(String route, Domain domain, Platform platform) {
        super(route, domain, platform);
    }

    @Override
    Request getRequest(Map<String, String> data) {
        String url = this.getURL() + "?" + this.getQuery(this.cleanData(data));
        return new GETRequest(Method.GET, url, this.getHeaders(), 5000);
    }

    private String getQuery(Map<String, String> data) {
        Map<String, String> authData = this.getAuthData(Method.GET, data);
        ArrayList<String> dataList = new ArrayList<String>();
        ArrayList<String> mapKeys = new ArrayList<String>(authData.keySet());
        for (String key : mapKeys) {
            try {
                dataList.add(key + "=" + URLEncoder.encode(authData.get(key), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw RootAPIException.wrap(e, NetworkException.UNSUPPORTED_ENCODING_EXCEPTION);
            }
        }
        return this.join("&", dataList);
    }

    private List<KeyValuePair> getHeaders() {
        List<KeyValuePair> headers = this.getCommonHeaders();
        String eTag = this.networkRequestDAO.getETag(this.route);
        if (eTag != null) {
            headers.add(new KeyValuePair("If-None-Match", eTag));
        }
        return headers;
    }
}

