/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.network.Network;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.Response;
import java.util.Map;

public class MetaCorrectedNetwork
implements Network {
    private final Network network;
    private final Jsonifier jsonifier;

    public MetaCorrectedNetwork(Network network, Platform platform) {
        this.network = network;
        this.jsonifier = platform.getJsonifier();
    }

    @Override
    public Response makeRequest(Map<String, String> data) {
        return this.makeRequest(data, 1);
    }

    private Response makeRequest(Map<String, String> data, int retryCount) {
        Response response = this.network.makeRequest(data);
        if (response.status == 413) {
            if (retryCount > 0) {
                data = this.removeCustomMeta(data);
                data = this.removeCustomIssueFieldData(data);
                return this.makeRequest(data, --retryCount);
            }
            throw RootAPIException.wrap(null, NetworkException.ENTITY_TOO_LARGE_RETRIES_EXHAUSTED);
        }
        return response;
    }

    private Map<String, String> removeCustomMeta(Map<String, String> data) {
        String meta = data.get("meta");
        data.put("meta", this.jsonifier.removeKeyFromJsonObjString(meta, "custom_meta"));
        return data;
    }

    private Map<String, String> removeCustomIssueFieldData(Map<String, String> data) {
        data.remove("custom_fields");
        return data;
    }
}

