/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.BaseNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.POSTRequest;
import com.helpshift.common.platform.network.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class POSTNetwork
extends BaseNetwork
implements Network {
    public POSTNetwork(String route, Domain domain, Platform platform) {
        super(route, domain, platform);
    }

    @Override
    Request getRequest(Map<String, String> data) {
        return new POSTRequest(Method.POST, this.getURL(), this.getQuery(this.cleanData(data)), this.getHeaders(), 5000);
    }

    private List<KeyValuePair> getHeaders() {
        List<KeyValuePair> headers = this.getCommonHeaders();
        headers.add(new KeyValuePair("Content-type", "application/x-www-form-urlencoded"));
        return headers;
    }

    private String getQuery(Map<String, String> data) {
        Map<String, String> authData = this.getAuthData(Method.POST, data);
        ArrayList<String> mapKeys = new ArrayList<String>(authData.keySet());
        ArrayList<KeyValuePair> params = new ArrayList<KeyValuePair>(mapKeys.size());
        for (String key : mapKeys) {
            params.add(new KeyValuePair(key, authData.get(key)));
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (KeyValuePair pair : params) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            try {
                result.append(URLEncoder.encode(pair.key, "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(pair.value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw RootAPIException.wrap(e, NetworkException.UNSUPPORTED_ENCODING_EXCEPTION);
            }
        }
        return result.toString();
    }
}

