/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.domain.network;

import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.BaseNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.Method;
import com.helpshift.common.platform.network.Request;
import com.helpshift.common.platform.network.UploadRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UploadNetwork
extends BaseNetwork {
    public UploadNetwork(String route, Domain domain, Platform platform) {
        super(route, domain, platform);
    }

    @Override
    Request getRequest(Map<String, String> data) {
        File screenshotFile = new File(data.get("screenshot"));
        String mimeType = this.getMimeType(screenshotFile.getPath());
        if (this.isMimeTypeSupported(mimeType)) {
            return new UploadRequest(Method.POST, this.getURL(), this.getAuthData(Method.POST, this.cleanData(data)), mimeType, this.getUploadHeaders(), 30000);
        }
        throw RootAPIException.wrap(null, NetworkException.UNSUPPORTED_MIME_TYPE);
    }

    private String getMimeType(String url) {
        try {
            FileInputStream inputStream = new FileInputStream(url);
            String type = URLConnection.guessContentTypeFromStream(inputStream);
            if (type == null) {
                type = URLConnection.guessContentTypeFromName(url);
            }
            ((InputStream)inputStream).close();
            return type;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isMimeTypeSupported(String type) {
        HashSet<String> types = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/gif", "image/x-png", "image/x-citrix-pjpeg", "image/x-citrix-gif", "image/pjpeg"));
        return types.contains(type);
    }

    private List<KeyValuePair> getUploadHeaders() {
        ArrayList<KeyValuePair> headers = new ArrayList<KeyValuePair>();
        headers.add(new KeyValuePair("Connection", "Keep-Alive"));
        headers.add(new KeyValuePair("Content-Type", "multipart/form-data;boundary=*****"));
        return headers;
    }
}

