/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.exception;

import com.helpshift.common.exception.ExceptionType;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.UnexpectedException;

public class RootAPIException
extends RuntimeException {
    public final String message;
    public final Exception exception;
    public final ExceptionType exceptionType;

    private RootAPIException(Exception exception, ExceptionType exceptionType, String message) {
        this.exception = exception;
        this.exceptionType = exceptionType;
        this.message = message;
    }

    public static RootAPIException wrap(Exception e) {
        return RootAPIException.wrap(e, null);
    }

    public static RootAPIException wrap(Exception e, ExceptionType type) {
        return RootAPIException.wrap(e, type, null);
    }

    public static RootAPIException wrap(Exception e, ExceptionType type, String message) {
        ExceptionType exceptionType;
        Exception exception;
        if (e instanceof RootAPIException) {
            RootAPIException rootAPIException = (RootAPIException)e;
            exception = rootAPIException.exception;
            exceptionType = type == null ? rootAPIException.exceptionType : type;
            if (message == null) {
                message = rootAPIException.message;
            }
        } else {
            exception = e;
            exceptionType = type == null ? UnexpectedException.GENERIC : type;
        }
        return new RootAPIException(exception, exceptionType, message);
    }

    public int getServerStatusCode() {
        int statusCode = 0;
        if (this.exceptionType instanceof NetworkException) {
            statusCode = ((NetworkException)this.exceptionType).serverStatusCode;
        }
        return statusCode;
    }

    public boolean shouldLog() {
        return this.exception != null;
    }
}

