/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.content.Context;
import com.helpshift.common.conversation.ConversationDB;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.dao.ConversationDAO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class AndroidConversationDAO
implements ConversationDAO {
    private ConversationDB conversationDB;

    AndroidConversationDAO(Context context) {
        this.conversationDB = ConversationDB.getInstance(context);
    }

    @Override
    public void dropAndCreateDatabase() {
        this.conversationDB.dropAndCreateDatabase();
    }

    @Override
    public synchronized ConversationDM readConversationWithoutMessages(String conversationServerId) {
        return this.conversationDB.readConversationWithServerId(conversationServerId);
    }

    @Override
    public synchronized ConversationDM readConversation(long conversationLocalId) {
        ConversationDM readableConversation = this.conversationDB.readConversationWithLocalId(conversationLocalId);
        if (readableConversation == null) {
            return null;
        }
        readableConversation.setMessageDMs(this.conversationDB.readMessages(conversationLocalId));
        return readableConversation;
    }

    @Override
    public synchronized List<ConversationDM> readConversationsWithoutMessages(long profileLocalId) {
        return this.conversationDB.readConversationsWithProfileId(profileLocalId);
    }

    @Override
    public synchronized void insertOrUpdateConversation(ConversationDM newConversation) {
        this.insertOrUpdateConversationWithoutMessages(newConversation);
        this.insertOrUpdateMessages(newConversation.messageDMs);
    }

    @Override
    public synchronized void insertOrUpdateConversationWithoutMessages(ConversationDM newConversation) {
        Long newLocalId = newConversation.localId;
        String newServerId = newConversation.serverId;
        if (newLocalId == null && newServerId == null) {
            return;
        }
        if (newLocalId == null && newServerId != null) {
            ConversationDM localConversation = this.conversationDB.readConversationWithServerId(newServerId);
            if (localConversation == null) {
                long localId = this.conversationDB.insertConversation(newConversation);
                if (localId != -1L) {
                    newConversation.setLocalId(localId);
                }
            } else {
                long localId = localConversation.localId;
                newConversation.setLocalId(localId);
                this.conversationDB.updateConversation(newConversation);
            }
        } else {
            ConversationDM localConversation = this.conversationDB.readConversationWithLocalId(newLocalId);
            if (localConversation == null) {
                long localId = this.conversationDB.insertConversation(newConversation);
                if (localId != -1L) {
                    newConversation.setLocalId(localId);
                }
            } else {
                this.conversationDB.updateConversation(newConversation);
            }
        }
    }

    @Override
    public synchronized void insertOrUpdateConversations(List<ConversationDM> conversations) {
        if (conversations.size() == 0) {
            return;
        }
        ArrayList<ConversationDM> newConversations = new ArrayList<ConversationDM>();
        ArrayList<ConversationDM> updatedConversations = new ArrayList<ConversationDM>();
        for (ConversationDM conversation : conversations) {
            ConversationDM localConversation;
            Long newLocalId = conversation.localId;
            String newServerId = conversation.serverId;
            if (newLocalId == null && newServerId == null) continue;
            if (newLocalId == null && newServerId != null) {
                localConversation = this.conversationDB.readConversationWithServerId(newServerId);
                if (localConversation == null) {
                    newConversations.add(conversation);
                    continue;
                }
                conversation.setLocalId(localConversation.localId);
                updatedConversations.add(conversation);
                continue;
            }
            localConversation = this.conversationDB.readConversationWithLocalId(newLocalId);
            if (localConversation == null) {
                newConversations.add(conversation);
                continue;
            }
            updatedConversations.add(conversation);
        }
        List<Long> localIds = this.conversationDB.insertConversations(newConversations);
        HashSet<ConversationDM> failedConversations = new HashSet<ConversationDM>();
        for (int i = 0; i < newConversations.size(); ++i) {
            long localId = localIds.get(i);
            ConversationDM newConversation = (ConversationDM)newConversations.get(i);
            if (localId == -1L) {
                failedConversations.add(newConversation);
                continue;
            }
            newConversation.setLocalId(localId);
        }
        this.conversationDB.updateConversations(updatedConversations);
        ArrayList<MessageDM> allMessages = new ArrayList<MessageDM>();
        for (ConversationDM conversation : conversations) {
            if (failedConversations.contains(conversation)) continue;
            allMessages.addAll(conversation.messageDMs);
        }
        this.insertOrUpdateMessages(allMessages);
    }

    @Override
    public synchronized List<MessageDM> readMessages(long conversationLocalId) {
        return this.conversationDB.readMessages(conversationLocalId);
    }

    @Override
    public synchronized void insertOrUpdateMessage(MessageDM newMessage) {
        Long newLocalId = newMessage.localId;
        String newServerId = newMessage.serverId;
        if (newLocalId == null && newServerId == null) {
            long localId = this.conversationDB.insertMessage(newMessage);
            if (localId != -1L) {
                newMessage.localId = localId;
            }
        } else if (newLocalId == null && newServerId != null) {
            MessageDM localMessage = this.conversationDB.readMessageWithServerId(newServerId);
            if (localMessage == null) {
                long localId = this.conversationDB.insertMessage(newMessage);
                if (localId != -1L) {
                    newMessage.localId = localId;
                }
            } else {
                newMessage.localId = localMessage.localId;
                this.conversationDB.updateMessage(newMessage);
            }
        } else {
            MessageDM localMessage = this.conversationDB.readMessageWithLocalId(newLocalId);
            if (localMessage == null) {
                long localId = this.conversationDB.insertMessage(newMessage);
                if (localId != -1L) {
                    newMessage.localId = localId;
                }
            } else {
                this.conversationDB.updateMessage(newMessage);
            }
        }
    }

    @Override
    public synchronized void insertOrUpdateMessages(List<MessageDM> messages) {
        if (messages.size() == 0) {
            return;
        }
        ArrayList<MessageDM> newMessages = new ArrayList<MessageDM>();
        ArrayList<MessageDM> updatedMessages = new ArrayList<MessageDM>();
        for (MessageDM messageDM : messages) {
            MessageDM localMessage;
            Long newLocalId = messageDM.localId;
            String newServerId = messageDM.serverId;
            if (newLocalId == null && newServerId == null) {
                newMessages.add(messageDM);
                continue;
            }
            if (newLocalId == null && newServerId != null) {
                localMessage = this.conversationDB.readMessageWithServerId(newServerId);
                if (localMessage == null) {
                    newMessages.add(messageDM);
                    continue;
                }
                messageDM.localId = localMessage.localId;
                updatedMessages.add(messageDM);
                continue;
            }
            localMessage = this.conversationDB.readMessageWithLocalId(newLocalId);
            if (localMessage == null) {
                newMessages.add(messageDM);
                continue;
            }
            updatedMessages.add(messageDM);
        }
        List<Long> localIds = this.conversationDB.insertMessages(newMessages);
        for (int i = 0; i < newMessages.size(); ++i) {
            long localId = localIds.get(i);
            if (localId == -1L) continue;
            ((MessageDM)newMessages.get((int)i)).localId = localId;
        }
        this.conversationDB.updateMessages(updatedMessages);
    }
}

