/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.content.Context;
import com.helpshift.common.StringUtils;
import com.helpshift.common.conversation.ConversationDB;
import com.helpshift.common.platform.KVStore;
import com.helpshift.conversation.dao.ConversationInboxDAO;
import com.helpshift.conversation.dao.PushNotificationData;
import com.helpshift.conversation.dto.ConversationDetailDTO;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.dto.dao.ConversationInboxRecord;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidConversationInboxDAO
implements ConversationInboxDAO {
    private static final String KEY_PUSH_NOTIFICATION_DATA = "push_notification_data";
    private static final String KEY_NOTIFICATION_COUNT = "notification_count";
    private static final String KEY_NOTIFICATION_TITLE = "notification_title";
    private ConversationDB conversationDB;
    private KVStore kvStore;

    public AndroidConversationInboxDAO(Context context, KVStore kvStore) {
        this.conversationDB = ConversationDB.getInstance(context);
        this.kvStore = kvStore;
    }

    private synchronized ConversationInboxRecord.Builder getConversationInboxRecordBuilder(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        ConversationInboxRecord.Builder builder = record == null ? new ConversationInboxRecord.Builder(profileLocalId) : new ConversationInboxRecord.Builder(record);
        return builder;
    }

    @Override
    public synchronized void saveDescriptionDetail(long profileLocalId, ConversationDetailDTO descriptionDetail) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(profileLocalId);
        builder.setDescription(descriptionDetail.title);
        builder.setDescriptionTimeStamp(descriptionDetail.timestamp);
        builder.setDescriptionType(descriptionDetail.type);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized ConversationDetailDTO getDescriptionDetail(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        ConversationDetailDTO conversationDetailDTO = null;
        if (record != null) {
            String title = record.description;
            long timeStamp = record.descriptionTimeStamp;
            int type = record.descriptionType;
            if (!StringUtils.isEmpty(title)) {
                conversationDetailDTO = new ConversationDetailDTO(title, timeStamp, type);
            }
        }
        return conversationDetailDTO;
    }

    @Override
    public synchronized void saveName(long profileLocalId, String name) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(profileLocalId);
        builder.setFormName(name);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getName(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        String result = null;
        if (record != null) {
            result = record.formName;
        }
        return result;
    }

    @Override
    public synchronized void saveEmail(long profileLocalId, String email) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(profileLocalId);
        builder.setFormEmail(email);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getEmail(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        String result = null;
        if (record != null) {
            result = record.formEmail;
        }
        return result;
    }

    @Override
    public synchronized void saveImageAttachment(long profileLocalId, ImagePickerFile imageAttachment) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(profileLocalId);
        builder.setImageAttachmentDraft(imageAttachment);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized ImagePickerFile getImageAttachment(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        ImagePickerFile result = null;
        if (record != null) {
            result = record.imageAttachmentDraft;
        }
        return result;
    }

    @Override
    public synchronized void saveConversationInboxTimestamp(long profileLocalId, String timestamp) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(profileLocalId);
        builder.setLastSyncTimestamp(timestamp);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getConversationInboxTimestamp(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        String result = null;
        if (record != null) {
            result = record.lastSyncTimestamp;
        }
        return result;
    }

    @Override
    public synchronized void saveConversationArchivalPrefillText(long profileLocalId, String prefillText) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(profileLocalId);
        builder.setArchivalText(prefillText);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getConversationArchivalPrefillText(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        String result = null;
        if (record != null) {
            result = record.archivalText;
        }
        return result;
    }

    @Override
    public synchronized void saveUserReplyDraft(long profileLocalId, String replyText) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(profileLocalId);
        builder.setReplyText(replyText);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public synchronized String getUserReplyDraft(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        String result = null;
        if (record != null) {
            result = record.replyText;
        }
        return result;
    }

    @Override
    public synchronized void savePersistMessageBox(long profileLocalId, boolean value) {
        ConversationInboxRecord.Builder builder = this.getConversationInboxRecordBuilder(profileLocalId);
        builder.setPersistMessageBox(value);
        this.conversationDB.storeConversationInboxRecord(builder.build());
    }

    @Override
    public PushNotificationData getPushNotificationData(String conversationServerId) {
        String serializeData = this.kvStore.getString(KEY_PUSH_NOTIFICATION_DATA);
        if (StringUtils.isEmpty(serializeData)) {
            return null;
        }
        PushNotificationData notificationData = null;
        try {
            JSONObject allNotifications = new JSONObject(serializeData);
            if (allNotifications.has(conversationServerId)) {
                JSONObject conversationData = allNotifications.getJSONObject(conversationServerId);
                int count = conversationData.getInt(KEY_NOTIFICATION_COUNT);
                String title = conversationData.getString(KEY_NOTIFICATION_TITLE);
                notificationData = new PushNotificationData(count, title);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return notificationData;
    }

    @Override
    public void setPushNotificationData(String conversationServerId, PushNotificationData pushNotificationData) {
        String serializeData = this.kvStore.getString(KEY_PUSH_NOTIFICATION_DATA);
        if (StringUtils.isEmpty(serializeData)) {
            serializeData = "{}";
        }
        try {
            JSONObject allNotifications = new JSONObject(serializeData);
            if (pushNotificationData == null) {
                allNotifications.remove(conversationServerId);
            } else {
                JSONObject pushData = new JSONObject();
                pushData.put(KEY_NOTIFICATION_COUNT, pushNotificationData.count);
                pushData.put(KEY_NOTIFICATION_TITLE, (Object)pushNotificationData.title);
                allNotifications.put(conversationServerId, (Object)pushData);
            }
            this.kvStore.setString(KEY_PUSH_NOTIFICATION_DATA, allNotifications.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean getPersistMessageBox(long profileLocalId) {
        ConversationInboxRecord record = this.conversationDB.readConversationInboxRecord(profileLocalId);
        boolean result = false;
        if (record != null) {
            result = record.persistMessageBox;
        }
        return result;
    }
}

