/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import com.helpshift.common.platform.KVStore;
import com.helpshift.faq.dao.FaqEventDAO;
import java.util.HashMap;
import java.util.Map;

public class AndroidFaqEventDAO
implements FaqEventDAO {
    private static final String KEY_FAQ_MARK_EVENTS = "key_faq_mark_event";
    private KVStore kvStore;

    public AndroidFaqEventDAO(KVStore kvStore) {
        this.kvStore = kvStore;
    }

    @Override
    public void insertFaqMarkHelpfulEvent(String faqId, boolean isHelpful) {
        HashMap<String, Boolean> unsentEvents = this.getFaqMarkEventFromDB();
        unsentEvents.put(faqId, isHelpful);
        this.kvStore.setSerializable(KEY_FAQ_MARK_EVENTS, unsentEvents);
    }

    @Override
    public void removeFaqMarkHelpfulEvent(String faqId) {
        HashMap<String, Boolean> unsentEvents = this.getFaqMarkEventFromDB();
        if (unsentEvents.containsKey(faqId)) {
            unsentEvents.remove(faqId);
            this.kvStore.setSerializable(KEY_FAQ_MARK_EVENTS, unsentEvents);
        }
    }

    @Override
    public Map<String, Boolean> getUnSentFaqMarkHelpfulEvents() {
        return this.getFaqMarkEventFromDB();
    }

    private synchronized HashMap<String, Boolean> getFaqMarkEventFromDB() {
        Object fromDB = this.kvStore.getSerializable(KEY_FAQ_MARK_EVENTS);
        HashMap<String, Boolean> unsentEvents = fromDB instanceof HashMap ? (HashMap<String, Boolean>)fromDB : new HashMap<String, Boolean>();
        return unsentEvents;
    }
}

