/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.common.platform;

import android.os.Build;
import com.helpshift.android.commons.downloader.HelpshiftSSLSocketFactory;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.network.NetworkConstants;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.network.HTTPTransport;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.common.platform.network.POSTRequest;
import com.helpshift.common.platform.network.Request;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.UploadRequest;
import com.helpshift.util.HSLogger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class AndroidHTTPTransport
implements HTTPTransport {
    private static final String TAG = "Helpshift_HTTPTrnsport";

    @Override
    public Response makeRequest(Request request) {
        if (request instanceof UploadRequest) {
            return this.upload((UploadRequest)UploadRequest.class.cast(request));
        }
        return this.makePostOrGetRequest(request);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response makePostOrGetRequest(Request request) {
        ArrayList<KeyValuePair> responseHeaders;
        int status;
        HttpURLConnection connection;
        block22: {
            String line;
            connection = null;
            if ("https://".equals(NetworkConstants.scheme)) {
                connection = (HttpsURLConnection)new URL(request.url).openConnection();
                this.fixSSLSocketProtocols((HttpsURLConnection)connection);
            } else {
                connection = (HttpURLConnection)new URL(request.url).openConnection();
            }
            connection.setRequestMethod(request.method.name());
            connection.setConnectTimeout(request.timeout);
            for (KeyValuePair header : request.headers) {
                connection.setRequestProperty(header.key, header.value);
            }
            if (request instanceof POSTRequest) {
                connection.setDoOutput(true);
                OutputStream outputStream = connection.getOutputStream();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                writer.write(((POSTRequest)POSTRequest.class.cast((Object)request)).query);
                writer.flush();
                writer.close();
                outputStream.flush();
                outputStream.close();
            }
            status = connection.getResponseCode();
            responseHeaders = new ArrayList<KeyValuePair>();
            Map<String, List<String>> headers = connection.getHeaderFields();
            for (String string2 : headers.keySet()) {
                if (StringUtils.isEmpty(string2)) continue;
                responseHeaders.add(new KeyValuePair(string2, headers.get(string2).get(0)));
            }
            if (status < 200 || status >= 300) break block22;
            FilterInputStream response = new BufferedInputStream(connection.getInputStream());
            for (String key : headers.keySet()) {
                if (StringUtils.isEmpty(key) || !key.equals("Content-Encoding") || !headers.get(key).get(0).equals("gzip")) continue;
                response = new GZIPInputStream(response);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(response);
            BufferedReader rd = new BufferedReader(inputStreamReader);
            StringBuilder responseStr = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                responseStr.append(line);
            }
            ((InputStream)response).close();
            inputStreamReader.close();
            Response response2 = new Response(status, responseStr.toString(), responseHeaders);
            try {
                if (connection == null) return response2;
                connection.disconnect();
                return response2;
            }
            catch (Exception e) {
                NetworkException networkException = NetworkException.GENERIC;
                networkException.route = request.url;
                throw RootAPIException.wrap(e, networkException, "Network error");
            }
        }
        HSLogger.d(TAG, "Api : " + request.url + " \t Status : " + status + "\t Thread : " + Thread.currentThread().getName());
        Response response = new Response(status, null, responseHeaders);
        try {
            if (connection == null) return response;
            connection.disconnect();
            return response;
        }
        catch (Exception exception) {
            NetworkException networkException = NetworkException.GENERIC;
            networkException.route = request.url;
            throw RootAPIException.wrap(exception, networkException, "Network error");
        }
        catch (UnknownHostException e) {
            try {
                NetworkException networkException = NetworkException.UNKNOWN_HOST;
                networkException.route = request.url;
                throw RootAPIException.wrap(e, networkException, "Network error");
                catch (SecurityException | SocketException e2) {
                    networkException = NetworkException.NO_CONNECTION;
                    networkException.route = request.url;
                    throw RootAPIException.wrap(e2, networkException, "Network error");
                }
                catch (SSLPeerUnverifiedException e3) {
                    networkException = NetworkException.SSL_PEER_UNVERIFIED;
                    networkException.route = request.url;
                    throw RootAPIException.wrap(e3, networkException, "Network error");
                }
                catch (SSLHandshakeException e4) {
                    networkException = NetworkException.SSL_HANDSHAKE;
                    networkException.route = request.url;
                    throw RootAPIException.wrap(e4, networkException, "Network error");
                }
                catch (IOException e5) {
                    networkException = NetworkException.GENERIC;
                    networkException.route = request.url;
                    throw RootAPIException.wrap(e5, networkException, "Network error");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connection == null) throw throwable;
                    connection.disconnect();
                    throw throwable;
                }
                catch (Exception e6) {
                    NetworkException networkException = NetworkException.GENERIC;
                    networkException.route = request.url;
                    throw RootAPIException.wrap(e6, networkException, "Network error");
                }
            }
        }
    }

    private void fixSSLSocketProtocols(HttpsURLConnection connection) {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT <= 19) {
            ArrayList<String> enableProtocols = new ArrayList<String>();
            enableProtocols.add("TLSv1.2");
            ArrayList<String> disableProtocols = new ArrayList<String>();
            disableProtocols.add("SSLv3");
            SSLSocketFactory sslSocketFactory = connection.getSSLSocketFactory();
            connection.setSSLSocketFactory(new HelpshiftSSLSocketFactory(sslSocketFactory, enableProtocols, disableProtocols));
        }
    }

    private boolean isInValidKeyForHeader(String key) {
        return "screenshot".equals(key) || "originalFileName".equals(key);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response upload(UploadRequest uploadRequest) {
        int status;
        HttpURLConnection connection;
        block22: {
            String line;
            connection = null;
            URL url = new URL(uploadRequest.url);
            String twoHyphens = "--";
            String boundary = "*****";
            String lineEnd = "\r\n";
            if ("https://".equals(NetworkConstants.scheme)) {
                connection = (HttpsURLConnection)url.openConnection();
                this.fixSSLSocketProtocols((HttpsURLConnection)connection);
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod(uploadRequest.method.name());
            connection.setConnectTimeout(uploadRequest.timeout);
            connection.setReadTimeout(uploadRequest.timeout);
            List headers = uploadRequest.headers;
            for (KeyValuePair header : headers) {
                connection.setRequestProperty(header.key, header.value);
            }
            DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
            outputStream.writeBytes(twoHyphens + boundary + lineEnd);
            Map<String, String> data = uploadRequest.data;
            ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
            for (String key : mapKeys) {
                if (this.isInValidKeyForHeader(key)) continue;
                String value = data.get(key);
                outputStream.writeBytes("Content-Disposition: form-data; name=\"" + key + "\"; " + lineEnd);
                outputStream.writeBytes("Content-Type: text/plain;charset=UTF-8" + lineEnd);
                outputStream.writeBytes("Content-Length: " + value.length() + lineEnd);
                outputStream.writeBytes(lineEnd);
                outputStream.writeBytes(value + lineEnd);
                outputStream.writeBytes(twoHyphens + boundary + lineEnd);
            }
            File screenshotFile = new File(data.get("screenshot"));
            String fileName = data.get("originalFileName");
            if (fileName == null) {
                fileName = screenshotFile.getName();
            }
            FileInputStream fileInputStream = new FileInputStream(screenshotFile);
            outputStream.writeBytes(twoHyphens + boundary + lineEnd);
            outputStream.writeBytes("Content-Disposition: form-data; name=\"screenshot\"; filename=\"" + fileName + "\"" + lineEnd);
            outputStream.writeBytes("Content-Type: " + uploadRequest.mimeType + lineEnd);
            outputStream.writeBytes("Content-Length: " + screenshotFile.length() + lineEnd);
            outputStream.writeBytes(lineEnd);
            int maxBufferSize = 0x100000;
            int bytesAvailable = fileInputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                outputStream.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            outputStream.writeBytes(lineEnd);
            outputStream.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
            fileInputStream.close();
            outputStream.flush();
            outputStream.close();
            status = connection.getResponseCode();
            StringBuilder responseStr = new StringBuilder();
            InputStream responseStream = connection.getInputStream();
            InputStreamReader inputStream = new InputStreamReader(responseStream);
            BufferedReader rd = new BufferedReader(inputStream);
            while ((line = rd.readLine()) != null) {
                responseStr.append(line);
            }
            String response = responseStr.toString();
            if (status < 200 || status >= 300) break block22;
            Response response2 = new Response(status, response, null);
            try {
                if (connection == null) return response2;
                connection.disconnect();
                return response2;
            }
            catch (Exception e) {
                NetworkException networkException = NetworkException.GENERIC;
                networkException.route = uploadRequest.url;
                throw RootAPIException.wrap(e, networkException, "Network error");
            }
        }
        Response response = new Response(status, null, null);
        try {
            if (connection == null) return response;
            connection.disconnect();
            return response;
        }
        catch (Exception e) {
            NetworkException networkException = NetworkException.GENERIC;
            networkException.route = uploadRequest.url;
            throw RootAPIException.wrap(e, networkException, "Network error");
        }
        catch (UnknownHostException e) {
            try {
                NetworkException networkException = NetworkException.UNKNOWN_HOST;
                networkException.route = uploadRequest.url;
                throw RootAPIException.wrap(e, networkException, "Upload error");
                catch (SecurityException | SocketException e2) {
                    networkException = NetworkException.NO_CONNECTION;
                    networkException.route = uploadRequest.url;
                    throw RootAPIException.wrap(e2, networkException, "Upload error");
                }
                catch (SSLPeerUnverifiedException e3) {
                    networkException = NetworkException.SSL_PEER_UNVERIFIED;
                    networkException.route = uploadRequest.url;
                    throw RootAPIException.wrap(e3, networkException, "Upload error");
                }
                catch (SSLHandshakeException e4) {
                    networkException = NetworkException.SSL_HANDSHAKE;
                    networkException.route = uploadRequest.url;
                    throw RootAPIException.wrap(e4, networkException, "Upload error");
                }
                catch (Exception e5) {
                    networkException = NetworkException.GENERIC;
                    networkException.route = uploadRequest.url;
                    throw RootAPIException.wrap(e5, networkException, "Upload error");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connection == null) throw throwable;
                    connection.disconnect();
                    throw throwable;
                }
                catch (Exception e6) {
                    NetworkException networkException = NetworkException.GENERIC;
                    networkException.route = uploadRequest.url;
                    throw RootAPIException.wrap(e6, networkException, "Network error");
                }
            }
        }
    }
}

